# Overview

This library contains an Android WatchFaceService implementation which can be used to run a MicroEJ Application on Android WearOS using the MicroEJ support engine.

The WearOS Application must depend on this library, extend the abstract class `com.microej.android.wearos.MicroEJWatchFaceService` and implement the abstract method `getRunnable()` to provide a `Runnable` instance which starts the MicroEJ Application.

This new class must then be declared in the `AndroidManifest.xml` file of the WearOS Application like a classic watchface service.

# Usage

Add the following line to your `build.gradle`:

    implementation 'com.microej.android.support:microej-wearos:2.0.1'

# Requirements

- Android SDK Platform 26

Besides, the following Gradle dependencies are required in the Android Studio project:

```
implementation("androidx.wear.watchface:watchface:1.1.1")
implementation("androidx.wear.watchface:watchface-guava:1.1.1")
```

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A.

# Restrictions

None.

---
_Copyright 2022-2023 MicroEJ Corp. All rights reserved._  
_MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms._
