/*
 * Java
 *
 * Copyright 2017-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.property;

import ej.service.loader.SystemPropertiesServiceLoader;

/**
 * The factory that retrieves the unique instance of the {@link SharedPropertyRegistry} sets by the system.
 */
public class SharedPropertyFactory {

	private static final SharedPropertyRegistry SHARED_PROPERTY_REGISTRY = getSharedPropertyRegistryInstance();

	private SharedPropertyFactory() {
	}

	private static SharedPropertyRegistry getSharedPropertyRegistryInstance() {
		SharedPropertyRegistry sharedPropertyRegistry = new SystemPropertiesServiceLoader()
				.getService(SharedPropertyRegistry.class);
		if (sharedPropertyRegistry == null) {
			throw new IllegalArgumentException();
		}
		return sharedPropertyRegistry;
	}

	/**
	 * Gets the global {@link SharedPropertyRegistry}.
	 *
	 * @return the global {@link SharedPropertyRegistry}.
	 */
	public static SharedPropertyRegistry getSharedPropertyRegistry() {
		return SHARED_PROPERTY_REGISTRY;
	}

}
