/*
 * Copyright 2023-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.fp.widget.display.buffer;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.Widget;
import ej.fp.widget.display.DisplayBufferManager;
import ej.microui.display.Rectangle;

/**
 * Only one buffer.
 */
public class DirectBufferPolicy implements DisplayBufferPolicy {

	private Widget displayWidget;
	private Image buffer;

	@Override
	public void setDisplayProperties(Widget displayWidget, int width, int height, int initialColor) {
		this.displayWidget = displayWidget;
		this.buffer = FrontPanel.getFrontPanel().newImage(width, height, initialColor, false);
	}

	@Override
	public int getBufferCount() {
		return 1;
	}

	@Override
	public boolean isDoubleBuffered() {
		return false;
	}

	@Override
	public void flush(DisplayBufferManager bufferManager, Rectangle[] rectangles) {
		this.displayWidget.repaint();
		bufferManager.simulateFlushTime();
	}

	@Override
	public Image getBackBuffer() {
		return this.buffer;
	}

	@Override
	public Image getFrontBuffer() {
		return this.buffer;
	}

	@Override
	public void dispose() {
		FrontPanel.getFrontPanel().disposeIfNotNull(this.buffer);
	}

}
