/*
 * 2019 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.bon;

/**
 * This class provides access to compile-time constants. A constant is retrieved
 * from its name, and is replaced by its value using the desired
 * <code>getXXX</code> method depending on the expected type.
 * <p>
 * The constant name must be resolved by the compiler as a String literal at the
 * location where the <code>getXXX</code> method is called. Constant Expressions
 * are specified in section <code>15.28 Constant Expressions</code> of the Java
 * Language Specification.
 * <p>
 * The following usages are allowed:
 *
 * <pre>
 * // Name is a String Literal
 * boolean value = Constants.getBoolean("MyConstant")
 * </pre>
 *
 * <pre>
 * // Name is a Field Access to a static final field declaration
 * // of type String, and initialized with a Constant Expression
 * static final String MY_CONSTANT = "My" + "Constant";
 * boolean value = Constants.getBoolean(MY_CONSTANT)
 * </pre>
 *
 * The following usages are not allowed:
 *
 * <pre>
 * // Name is a String Object
 * boolean value = Constants.getBoolean(new String("MyConstant"))
 * </pre>
 *
 * <pre>
 * // Name is a Field Access to a static final field declaration
 * // of type String, but not initialized with a Constant Expression
 * static final String MY_CONSTANT = getMyConstantName();
 * boolean value = Constants.getBoolean(MY_CONSTANT)
 * </pre>
 */
public class Constants {

	private Constants() {
	}

	/**
	 * Gets a <code>boolean</code> constant.
	 * <p>
	 * The constant is resolved to <code>true</code> if its value is equals to
	 * <code>"true"</code>, <code>false</code> if its value is equals to
	 * <code>"false"</code>.
	 *
	 * @param name
	 *            the constant name
	 * @return the boolean constant
	 */
	public static boolean getBoolean(String name) {
		throw new RuntimeException();
	}

	/**
	 * Gets a <code>byte</code> constant.
	 * <p>
	 * The constant is resolved to a <code>byte</code> if its value is resolved to
	 * an <code>int</code> included into the range <code>[-128,127]</code>.
	 *
	 * @param name
	 *            the constant name
	 * @return the byte constant
	 * @see #getInt(String)
	 */
	public static byte getByte(String name) {
		throw new RuntimeException();
	}

	/**
	 * Gets a <code>char</code> constant.
	 * <p>
	 * The constant is resolved to a <code>char</code> if its value is resolved to
	 * an <code>int</code> included into the range <code>[0,65535]</code>.
	 *
	 * @param name
	 *            the constant name
	 * @return the char constant
	 * @see #getInt(String)
	 */
	public static char getChar(String name) {
		throw new RuntimeException();
	}

	/**
	 * Gets a <code>short</code> constant.
	 * <p>
	 * The constant is resolved to a <code>short</code> if its value is resolved to
	 * an <code>int</code> included into the range <code>[-32768,32767]</code>.
	 *
	 * @param name
	 *            the constant name
	 * @return the short constant
	 * @see #getInt(String)
	 */
	public static short getShort(String name) {
		throw new RuntimeException();
	}

	/**
	 * Gets an <code>int</code> constant.
	 * <p>
	 * The constant is resolved to an <code>int</code> if its {@link String} value:
	 * <ul>
	 * <li>is a valid argument for {@link Integer#decode(String)}</li>
	 * <li>is an unsigned integer written in hexadecimal format such as
	 * <code>0xFFFFFFFF</code>. In this latter case, the constant is resolved to
	 * <code>-1</code>.</li>
	 * </ul>
	 *
	 * @param name
	 *            the constant name
	 * @return the int constant
	 */
	public static int getInt(String name) {
		throw new RuntimeException();
	}

	/**
	 * Gets a <code>long</code> constant.
	 * <p>
	 * The constant is resolved to a <code>long</code> if its {@link String} value:
	 * <ul>
	 * <li>is a valid argument for {@link Long#decode(String)}</li>
	 * <li>if an unsigned long written in hexadecimal format such as
	 * <code>0xFFFFFFFFFFFFFFFF</code>. In this latter case, the constant is
	 * resolved to <code>-1</code>.</li>
	 * </ul>
	 *
	 * @param name
	 *            the constant name
	 * @return the long constant
	 */
	public static long getLong(String name) {
		throw new RuntimeException();
	}

	/**
	 * Gets a <code>float</code> constant.
	 * <p>
	 * The constant is resolved to a <code>float</code> if its value can be loaded
	 * by {@link Float#valueOf(String)}.
	 *
	 * @param name
	 *            the constant name
	 * @return the float constant
	 */
	public static float getFloat(String name) {
		throw new RuntimeException();
	}

	/**
	 * Gets a <code>double</code> constant.
	 * <p>
	 * The constant is resolved to a <code>double</code> if its value can be loaded
	 * by {@link Double#valueOf(String)}.
	 *
	 * @param name
	 *            the constant name
	 * @return the short constant
	 */
	public static double getDouble(String name) {
		throw new RuntimeException();
	}

	/**
	 * Gets a {@link String} constant.
	 *
	 * @param name
	 *            the constant name
	 * @return the String constant
	 */
	public static String getString(String name) {
		throw new RuntimeException();
	}

	/**
	 * Gets a {@link Class} constant.
	 * <p>
	 * The constant is resolved to a {@link Class} if its value describes the fully
	 * qualified name of a {@link Class} that can be loaded from the classpath.
	 *
	 * @param name
	 *            the constant name
	 * @return the {@link Class} constant
	 */
	public static Class<?> getClass(String name) {
		throw new RuntimeException();
	}
}
