package java.lang;

/**
 * Thrown to indicate that a thread has attempted to wait on an object's monitor or to notify other
 * threads waiting on an object's monitor without owning the specified monitor.
 * 
 * @see java.lang.Object#notify()
 * @see java.lang.Object#notifyAll()
 * @see java.lang.Object#wait()
 * @see java.lang.Object#wait(long)
 * @see java.lang.Object#wait(long, int)
 */
public class IllegalMonitorStateException extends RuntimeException {

	/**
	 * Constructs an <code>IllegalMonitorStateException</code> with no detail message.
	 */
	public IllegalMonitorStateException() {
		throw new RuntimeException();
	}

	/**
	 * Constructs an <code>IllegalMonitorStateException</code> with the specified detail message.
	 * 
	 * @param s
	 *        the detail message.
	 */
	public IllegalMonitorStateException(String s) {
		throw new RuntimeException();
	}
}