/*
 * Java
 *
 * Copyright 2014-2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand;

/**
 * Manages the threads that will read the command from the {@link RemoteConnection}.
 */
public interface RemoteCommandManager extends CommandSenderProvider {

	/**
	 * Starts to read and execute the commands from the given {@link CommandReader} without connection listener.
	 * <p>
	 * A new thread is created.
	 * <p>
	 * This method behaves exactly as if it simply performs the call <code>startReading(connection, null)</code>.
	 *
	 * @param connection
	 *            the connection to read.
	 *
	 * @deprecated use {@link #startReading(RemoteConnection, String) instead}
	 */
	@Deprecated
	void startReading(RemoteConnection connection);

	/**
	 * Starts to read and execute the commands from the given {@link CommandReader}.
	 * <p>
	 * A new thread is created.
	 * <p>
	 * This method behaves exactly as if it simply performs the call <code>startReading(connection, null)</code>.
	 *
	 * @param connection
	 *            the connection to read.
	 * @param connectionName
	 *            the name of the connection to read.
	 */
	void startReading(RemoteConnection connection, String connectionName);

	/**
	 * Starts to read and execute the commands from the given {@link CommandReader}.
	 * <p>
	 * A new thread is created.
	 *
	 * @param connection
	 *            the connection to read.
	 * @param listener
	 *            the associated listener.
	 * @deprecated use {@link #startReading(RemoteConnection, String, RemoteConnectionListener) instead}
	 */
	@Deprecated
	void startReading(RemoteConnection connection, RemoteConnectionListener listener);

	/**
	 * Starts to read and execute the commands from the given {@link CommandReader}.
	 * <p>
	 * A new thread is created.
	 *
	 * @param connection
	 *            the connection to read.
	 * @param listener
	 *            the associated listener.
	 *
	 * @param connectionName
	 *            the name of the connection to read.
	 */
	void startReading(RemoteConnection connection, String connectionName, RemoteConnectionListener listener);

	/**
	 * Stops reading the commands from the given {@link CommandReader}.
	 *
	 * @param connection
	 *            the connection to stop to read.
	 */
	void stopReading(RemoteConnection connection);

	/**
	 * Stops all the connections.
	 */
	void stopAll();
}
