/*
 * Copyright 2014-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.websocket.frame;

import ej.websocket.ReasonForClosure;

/**
 * An IFrameBuilder knows how to create different kind of frames.
 *
 *
 *
 */
public interface IFrameBuilder {

	/**
	 * The maximum length for an extended payload (7+16 bits).
	 */
	int EXTENDED_LENGTH_MAX_VALUE = (1 << 16) - 1;

	/**
	 * See RFC6455, section 5.6. Data Frames.
	 *
	 * @param binary
	 *            the binary data to create a binary frame
	 * @return the properly constructed frame
	 */
	RawFrame buildBinaryFrame(byte[] binary);

	/**
	 * See RFC6455, section 7. Closing the Connection.
	 *
	 * @param reasonForClosure
	 *            the status code and the optional message to send to the remote endpoint
	 * @return the properly constructed frame
	 */
	RawFrame buildCloseFrame(ReasonForClosure reasonForClosure);

	/**
	 * See RFC6455, section 5.5.2. Ping.
	 *
	 * @param payload
	 *            the payload of the frame
	 *
	 * @return the properly constructed frame
	 */
	RawFrame buildPingFrame(byte[] payload);

	/**
	 * See RFC6455, section 5.5.3. Pong.
	 *
	 * @param payload
	 *            the payload of the frame
	 *
	 * @return the properly constructed frame
	 */
	RawFrame buildPongFrame(byte[] payload);

	/**
	 * See RFC6455, section 5.6. Data Frames.
	 *
	 * @param text
	 *            the text to create a text frame
	 * @return the properly constructed frame
	 */
	RawFrame buildTextFrame(String text);

}
