/*
 * Java
 *
 * Copyright 2018-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.basictool.map;

import ej.annotation.Nullable;

/**
 * This class implements the {@link AbstractPackedMap} class, using object-equality when comparing keys. In other words,
 * in an PackedMap, two keys k1 and k2 are considered equal if and only if <code>(k1.equals(k2))</code> (with k1 not
 * <code>null</code> for sure as long as this map does not accept <code>null</code> keys).
 *
 * @param <K>
 *            the type of keys maintained by this map.
 * @param <V>
 *            the type of mapped values.
 */
public class PackedMap<K, V> extends AbstractPackedMap<K, V> {

	/**
	 * Constructs an empty map.
	 */
	public PackedMap() {
		super();
	}

	/**
	 * Constructs a map with the same mappings as the specified map.
	 *
	 * @param map
	 *            the map whose mappings are to be placed in this map.
	 * @throws NullPointerException
	 *             if the specified map is <code>null</code>.
	 */
	public PackedMap(PackedMap<K, V> map) {
		super(map);
	}

	@Override
	public Object clone() {
		return new PackedMap<>(this);
	}

	@Override
	protected boolean isSame(Object key, @Nullable Object candidateKey) {
		assert candidateKey != null;
		return candidateKey.equals(key);
	}

}
