/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothScanFilter</code> class represents a scan filter which may be used in order to filter scan results
 * during a scan.
 * <p>
 * Scan filters can be created by calling the static methods of this class.
 */
public class BluetoothScanFilter {

	/**
	 * Private constructor.
	 */
	private BluetoothScanFilter() {
		throw new RuntimeException();
	}

	/**
	 * Creates a new scan filter. If this filter is set, no scan result will be discarded.
	 *
	 * @return the new scan filter.
	 */
	public static BluetoothScanFilter noFilter() {
		throw new RuntimeException();
	}

	/**
	 * Creates a new scan filter. If a scan result is received while this filter is set, the scan result is discarded if
	 * its advertisement data does not contain the field with the given type.
	 *
	 * @param type
	 *            the type of the field which must be present within the advertisement data (see
	 *            {@link ej.bluetooth.BluetoothDataTypes}).
	 *
	 * @return the new scan filter.
	 */
	public static BluetoothScanFilter fieldExists(byte type) {
		throw new RuntimeException();
	}

	/**
	 * Creates a new scan filter. If a scan result is received while this filter is set, the scan result is discarded if
	 * its advertisement data does not contain the field with the given type or if its data is not equal to the given
	 * data.
	 *
	 * @param type
	 *            the type of the field which must be present within the advertisement data (see
	 *            {@link ej.bluetooth.BluetoothDataTypes}).
	 * @param data
	 *            the data that the field must be equal to.
	 *
	 * @return the new scan filter.
	 */
	public static BluetoothScanFilter fieldEquals(byte type, byte[] data) {
		throw new RuntimeException();
	}

	/**
	 * Creates a new scan filter. If a scan result is received while this filter is set, the scan result is discarded if
	 * its advertisement data does not contain the field with the given type or if its data does not start with the
	 * given data.
	 *
	 * @param type
	 *            the type of the field which must be present within the advertisement data (see
	 *            {@link ej.bluetooth.BluetoothDataTypes}).
	 * @param data
	 *            the data that the field must start with.
	 *
	 * @return the new scan filter.
	 */
	public static BluetoothScanFilter fieldStartsWith(byte type, byte[] data) {
		throw new RuntimeException();
	}
}
