/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothStatus</code> interface enumerates the values for error codes of ATT requests.
 * <p>
 * Refer to «Core Vol 3, Part F, 3.4.1.1 Error Response» and to «Supplement Part B, 1.2 List of error codes».
 */
public interface BluetoothStatus {

	/** OK. */
	int OK = 0x00;

	/** Invalid handle. */
	int INVALID_HANDLE = 0x01;

	/** Read not permitted. */
	int READ_NOT_PERMITTED = 0x02;

	/** Write not permitted. */
	int WRITE_NOT_PERMITTED = 0x03;

	/** Invalid PDU. */
	int INVALID_PDU = 0x04;

	/** Insufficient authentication. */
	int INSUFFICIENT_AUTHENTICATION = 0x05;

	/** Request not supported. */
	int REQUEST_NOT_SUPPORTED = 0x06;

	/** Invalid offset. */
	int INVALID_OFFSET = 0x07;

	/** Insufficient authorization. */
	int INSUFFICIENT_AUTHORIZATION = 0x08;

	/** Prepare queue full. */
	int PREPARE_QUEUE_FULL = 0x09;

	/** Attribute not found. */
	int ATTRIBUTE_NOT_FOUND = 0x0A;

	/** Attribute not long. */
	int ATTRIBUTE_NOT_LONG = 0x0B;

	/** Insufficient key size. */
	int INSUFFICIENT_KEY_SIZE = 0x0C;

	/** Invalid value length. */
	int INVALID_VALUE_LENGTH = 0x0D;

	/** Unlikely. */
	int UNLIKELY = 0x0E;

	/** Insufficient encryption. */
	int INSUFFICIENT_ENCRYPTION = 0x0F;

	/** Unsupported group type. */
	int UNSUPPORTED_GROUP_TYPE = 0x10;

	/** Insufficient resources. */
	int INSUFFICIENT_RESOURCES = 0x11;

	/** Write request rejected. */
	int WRITE_REQUEST_REJECTED = 0xFC;

	/** CCC descriptor improperly configured. */
	int CCC_DESCRIPTOR_IMPROPERLY_CONFIGURED = 0xFD;

	/** Procedure already in progress. */
	int PROCEDURE_ALREADY_IN_PROGRESS = 0xFE;

	/** Out of range. */
	int OUT_OF_RANGE = 0xFF;
}
