/*
 * Copyright 2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.widget.debug;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

import ej.mwt.animation.Animation;
import ej.mwt.animation.Animator;

/**
 * Monitor for Animator.
 * <p>
 * It uses a {@link Logger} to log a warning message when none of the animations has requested a render during an
 * animator tick.
 */
public class AnimatorMonitor implements Animator.AnimatorListener {

	private static final Logger LOGGER = Logger.getLogger(AnimatorMonitor.class.getSimpleName());

	@Override
	public void onVoidTick(Animation[] animations) {
		if (LOGGER.isLoggable(Level.WARNING)) {
			LOGGER.warning("None of the animations has requested a render during the animator tick. Animations list: "
					+ Arrays.toString(animations));
		}
	}
}
