/*
 * Java
 *
 * Copyright 2016-2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.ecom.network;

import java.net.InetAddress;

/**
 * An IP configuration describes the settings of a network interface.
 */
public class IPConfiguration {

	/**
	 * Gets the DNS server addresses.
	 *
	 * @return the DNS addresses or <code>null</code> if not set.
	 */
	public InetAddress[] getDNS(){
		throw new RuntimeException();
	}

	/**
	 * Gets the gateway address.
	 *
	 * @return the gateway address or <code>null</code> if not set.
	 */
	public InetAddress getGateway(){
		throw new RuntimeException();
	}

	/**
	 * Gets the IP address.
	 *
	 * @return the IP address or <code>null</code> if not set.
	 */
	public InetAddress getIP(){
		throw new RuntimeException();
	}

	/**
	 * Gets the netmask.
	 *
	 * @return the netmask or <code>null</code> if not set.
	 */
	public InetAddress getNetmask(){
		throw new RuntimeException();
	}

	/**
	 * Tells whether the DNS server address is statically configured or retrieved
	 * from DHCP server. When DHCP is not used (see {@link #isStatic()}, the return
	 * of this method is not relevant.
	 *
	 * @return <code>true</code> for static DNS configuration, <code>false</code> if
	 *         DHCP is used also for DNS.
	 */
	public boolean isDNSStatic(){
		throw new RuntimeException();
	}

	/**
	 * Tells whether the IP configuration is set statically or retrieved from a DHCP
	 * server.
	 *
	 * @return <code>true</code> for static configuration, <code>false</code> if
	 *         DHCP is used.
	 */
	public boolean isStatic(){
		throw new RuntimeException();
	}

	/**
	 * Sets the addresses of the DNS servers.
	 *
	 * @param dnsList
	 *            the addresses of the DNS servers or <code>null</code>.
	 */
	public void setDNS(InetAddress[] dnsList){
		throw new RuntimeException();
	}

	/**
	 * Sets the IP address of the gateway.
	 *
	 * @param gateway
	 *            the IP address of the gateway or <code>null</code>.
	 */
	public void setGateway(InetAddress gateway){
		throw new RuntimeException();
	}

	/**
	 * Sets the IP address.
	 *
	 * @param ip
	 *            the IP address or <code>null</code>.
	 */
	public void setIP(InetAddress ip){
		throw new RuntimeException();
	}

	/**
	 * Sets the netmask.
	 *
	 * @param netmask
	 *            the netmask or <code>null</code>.
	 */
	public void setNetmask(InetAddress netmask){
		throw new RuntimeException();
	}

	/**
	 * Forces the use of DHCP or not.
	 *
	 * @param use
	 *            <code>true</code> to use DHCP, <code>false</code> for a static
	 *            configuration.
	 * @see #setIP(InetAddress)
	 */
	public void useDHCP(boolean use){
		throw new RuntimeException();
	}

	/**
	 * Selects the DNS configuration between a static statically configured DNS and
	 * the DNS given by DHCP server.
	 *
	 * @param use
	 *            <code>true</code> to use a static DNS, <code>false</code> for a
	 *            dynamic one.
	 * @see #setDNS(InetAddress[])
	 */
	public void useStaticDNS(boolean use){
		throw new RuntimeException();
	}
}
