/*
 * C
 *
 * Copyright 2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
#ifndef LLEVENT
#define LLEVENT

#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>

#define NO_ERR 0
#define ERR_WRONG_ARGS -1
#define ERR_FIFO_FULL -2

/**
 * Inserts an event into the FIFO.
 * <p>
 * The type must be higher than or equal to 0 and lower than 128.
 * The data must not exceed 24-bit. Otherwise use {@link #offerExtendedEvent()}.
 *
 * @return {@link NO_ERR} -> success, {@link ERR_WRONG_ARGS}  -> failed: illegal arguments, {@link ERR_FIFO_FULL}  -> failed: the FIFO is full
 */
int32_t LLEVENT_offerEvent(int32_t type, int32_t data);

/**
 * Inserts a extended event into the FIFO.
 * <p>
 * The type must be higher than or equal to 0 and lower than 128.
 * The data_length must not exceed 24-bit.
 *
 * @return {@link NO_ERR} -> success, {@link ERR_WRONG_ARGS}  -> failed: illegal arguments, {@link ERR_FIFO_FULL}  -> failed: the FIFO is full
 */
int32_t LLEVENT_offerExtendedEvent(int32_t type, void* data, int32_t data_length);


#endif
