/*
 * Copyright (c) 1996, 2008, Oracle and/or its affiliates. All rights reserved.
 * Copyright (C) 2016-2020 MicroEJ Corp. - EDC compliance and optimizations.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.net;

/**
 * Signals that an error occurred while attempting to bind a socket to a local address and port. Typically, the port is
 * in use, or the requested local address could not be assigned.
 *
 * @since JDK1.1
 */

public class BindException extends SocketException {
	private static final long serialVersionUID = -5945005768251722951L;

	/**
	 * Constructs a new BindException with the specified detail message as to why the bind error occurred. A detail
	 * message is a String that gives a specific description of this error.
	 *
	 * @param msg
	 *            the detail message
	 */
	public BindException(String msg) {
		super(msg);
	}

	/**
	 * Construct a new BindException with no detailed message.
	 */
	public BindException() {
	}
}
