/*
 * Copyright 2021-2023 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.android.application;

import android.graphics.Bitmap;
import android.graphics.Rect;

/**
 * Represents the display of an Android Application, on which a bitmap containing the back buffer can be drawn.
 */
public interface ApplicationDisplay {

	/**
	 * Flushes the given back buffer on the application display.
	 * <p>
	 * This method is called by the front panel when a flush is requested by the application and the tearing signal has
	 * been received.
	 *
	 * @param bitmap
	 *            a bitmap containing the back buffer.
	 * @param bounds
	 *            the bounds of the bitmap to flush.
	 */
	void flush(Bitmap bitmap, Rect bounds);
}
