/*
 * Java
 *
 * Copyright 2019 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display;

import ej.microui.display.transform.AbstractTransform;

/**
 * This class defines a {@link Renderable} with a <code>character</code> in a {@link Font}.
 *
 * @since 2.4
 */
public class RenderableChar implements Renderable {

	/**
	 * Creates an instance giving the character to render using an {@link AbstractTransform}. The renderable area is
	 * defined by the character representation in the giving font. The font ratio ({@link Font#setRatios(float, float)})
	 * is not used and reseted.
	 *
	 * @param f
	 *            the font which contains the character to render
	 * @param c
	 *            the character to render
	 */
	public RenderableChar(Font f, char c) {
		throw new RuntimeException();
	}

	/**
	 * Gets the font used to render the character.
	 *
	 * @return the character font.
	 */
	public Font getFont() {
		throw new RuntimeException();
	}

	/**
	 * Gets the character to render.
	 *
	 * @return the character to render.
	 */
	public char getChar() {
		throw new RuntimeException();
	}

	// @Override
	// public void draw(GraphicsContext gc, int x, int y, int anchor) {
	// throw new RuntimeException();
	// }

	@Override
	public int getWidth() {
		throw new RuntimeException();
	}

	@Override
	public int getHeight() {
		throw new RuntimeException();
	}

}
