/*
 * Java
 *
 * Copyright 2019 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display;

/**
 * This class represents an area to render on a {@link GraphicsContext}. This area has an original size (before any
 * transformation) and this size can be retrieved using {@link #getWidth()} and {@link #getHeight()} methods.
 *
 * @since 2.4
 */
public interface Renderable {

	/**
	 * Gets the area width to render.
	 *
	 * @return the area width (before any transformation).
	 */
	int getWidth();

	/**
	 * Gets the area height to render.
	 *
	 * @return the area height (before any transformation).
	 */
	int getHeight();

	// /**
	// * Draws the renderable at the given anchor point.
	// * <p>
	// * The renderable anchor point is at the given position. Position constants may be given to specify the precise
	// * location of the renderable around the anchor point.
	// *
	// * @param gc
	// * the graphics context where drawing the renderable.
	// * @param x
	// * the x coordinate of the anchor point.
	// * @param y
	// * the y coordinate of the anchor point.
	// * @param anchor
	// * position of the image around the anchor point.
	// * @throws IllegalArgumentException
	// * if the given anchor is not a valid value (for instance {@link GraphicsContext#BASELINE} is only
	// * allowed when drawing a renderable with a {@link Font}).
	// * @throws NullPointerException
	// * if graphics context is <code>null</code>.
	// */
	// void draw(GraphicsContext gc, int x, int y, int anchor);
}
