/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

import ej.bluetooth.callbacks.ClientCallbacks;
import ej.bluetooth.callbacks.ServerCallbacks;

/**
 * The <code>BluetoothService</code> class represents a remote or a local GATT service.
 * <p>
 * Remote services may be retrieved from a Bluetooth device by {@link BluetoothDevice#discoverServices discovering its
 * services}. The GATT events related to the remote service may be handled by {@link #setClientCallbacks setting the
 * client callbacks}.
 * <p>
 * Local services may be created by using the {@link #BluetoothService class constructor} and
 * {@link BluetoothAdapter#addService added} to an adapter. The GATT events related to the local service may be handled
 * by {@link #setServerCallbacks setting the server callbacks}.
 * <p>
 * This class provides methods to get information on the service. It also allows to add characteristics and included
 * services to a local service.
 */
public class BluetoothService {

	/**
	 * The <code>Type</code> class enumerates the values for service types.
	 */
	public enum Type {

		/** Primary service. */
		PRIMARY,

		/** Secondary service. */
		SECONDARY
	}

	/**
	 * Creates a local service with the given UUID and type.
	 * <p>
	 * This service may then be {@link BluetoothAdapter#addService added} to an adapter.
	 * <p>
	 * The GATT events related to this service may be handled by {@link #setServerCallbacks setting the server
	 * callbacks}.
	 *
	 * @param uuid
	 *            the service UUID.
	 * @param type
	 *            the service type (primary or secondary).
	 */
	public BluetoothService(BluetoothUuid uuid, Type type) {
		throw new RuntimeException();
	}

	/**
	 * Adds a characteristic to this service.
	 *
	 * @param characteristic
	 *            the characteristic to add.
	 * @throws IllegalStateException
	 *             if this service belongs to a remote device.
	 * @throws IllegalStateException
	 *             if this service has already been added to an adapter.
	 * @throws IllegalStateException
	 *             if the characteristic has already been added to a service.
	 */
	public void addCharacteristic(BluetoothCharacteristic characteristic) {
		throw new RuntimeException();
	}

	/**
	 * Adds a service to include in this service.
	 *
	 * @param service
	 *            the service to include.
	 * @throws IllegalStateException
	 *             if this service belongs to a remote device.
	 * @throws IllegalStateException
	 *             if this service has already been added to an adapter.
	 */
	public void addIncludedService(BluetoothService service) {
		throw new RuntimeException();
	}

	/**
	 * Returns the UUID of this service.
	 *
	 * @return the UUID of this service
	 */
	public BluetoothUuid getUuid() {
		throw new RuntimeException();
	}

	/**
	 * Returns the type of this service.
	 *
	 * @return the type of this service (primary or secondary).
	 */
	public Type getType() {
		throw new RuntimeException();
	}

	/**
	 * Returns the list of characteristics of this service.
	 *
	 * @return the list of characteristics of this service.
	 */
	public BluetoothCharacteristic[] getCharacteristics() {
		throw new RuntimeException();
	}

	/**
	 * Returns the list of services included in this service.
	 *
	 * @return the list of services included in this service.
	 */
	public BluetoothService[] getIncludedServices() {
		throw new RuntimeException();
	}

	/**
	 * Finds the characteristic of this service which matches the given UUID.
	 * <p>
	 * If multiple characteristics have the same UUID, any of them may be returned.
	 *
	 * @param characteristicUuid
	 *            the UUID of the characteristic to find.
	 * @return the characteristic found, or null if it can not be found.
	 */
	public BluetoothCharacteristic findCharacteristic(BluetoothUuid characteristicUuid) {
		throw new RuntimeException();
	}

	/**
	 * Finds the service included by this service which matches the given UUID.
	 * <p>
	 * If multiple included services have the same UUID, any of them may be returned.
	 *
	 * @param serviceUuid
	 *            the UUID of the service to find.
	 * @return the service found, or null if it can not be found.
	 */
	public BluetoothService findIncludedService(BluetoothUuid serviceUuid) {
		throw new RuntimeException();
	}

	/**
	 * Sets the object which will receive the client events related to this service.
	 *
	 * @param clientCallbacks
	 *            the object which will receive the client events.
	 * @throws IllegalStateException
	 *             if this service does not belong to a remote device.
	 */
	public void setClientCallbacks(ClientCallbacks clientCallbacks) {
		throw new RuntimeException();
	}

	/**
	 * Sets the object which will receive the server events related to this service.
	 *
	 * @param serverCallbacks
	 *            the object which will receive the server events.
	 * @throws IllegalStateException
	 *             if this service belongs to a remote device.
	 */
	public void setServerCallbacks(ServerCallbacks serverCallbacks) {
		throw new RuntimeException();
	}
}
