/*
 * Copyright 2016-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet.selector;

/**
 * Provides utility methods related to selectors.
 */
public class SelectorHelper {

	private static final int A_SHIFT = 24;
	private static final int B_SHIFT = 16;
	private static final int C_SHIFT = 8;
	private static final int D_SHIFT = 0;

	// Prevents initialization.
	private SelectorHelper() {
	}

	/**
	 * Computes the specificity of a selector.
	 *
	 * @param a
	 *            1 if the declaration is from is a 'style' attribute rather than a rule with a selector, 0 otherwise.
	 * @param b
	 *            the number of ID attributes in the selector.
	 * @param c
	 *            the number of other attributes and pseudo-classes in the selector.
	 * @param d
	 *            the number of widget names and pseudo-widgets in the selector.
	 * @return the selector specificity.
	 */
	public static int getSpecificity(int a, int b, int c, int d) {
		return (a << A_SHIFT) + (b << B_SHIFT) + (c << C_SHIFT) + (d << D_SHIFT);
	}
}
