/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.debug;

import ej.bon.Constants;
import ej.mwt.Desktop;
import ej.mwt.Widget;
import ej.mwt.render.RenderPolicy;
import ej.widget.debug.BoundsInspector;
import ej.widget.debug.HierarchyInspector;
import java.util.logging.Logger;

public class RenderMonitor
implements RenderPolicy.RenderListener {
    private static final String DEBUG_RENDER_FRAMES_CONSTANT = "ej.mwt.debug.render.frames";
    private static final String ON_S3 = "com.microej.library.microui.onS3";
    private static final Logger LOGGER = Logger.getLogger(RenderMonitor.class.getSimpleName());

    public void onRenderRequested(Widget widget, int x, int y, int width, int height) {
        LOGGER.info(RenderMonitor.buildMessage("Render requested on ", widget, x, y, width, height, true));
    }

    public void onRenderExecuted(Widget widget, int x, int y, int width, int height) {
        LOGGER.info(RenderMonitor.buildMessage("Render executed on  ", widget, x, y, width, height, false));
    }

    private static String buildMessage(String prefix, Widget widget, int x, int y, int width, int height, boolean appendCaller) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(HierarchyInspector.pathToWidgetToString(widget));
        builder.append(" at {").append(x).append(',').append(y).append(' ').append(width).append('x').append(height).append("} of {");
        BoundsInspector.appendAbsolutePosition(builder, widget);
        builder.append(' ');
        BoundsInspector.appendSize(builder, widget);
        builder.append('}');
        if (appendCaller) {
            RenderMonitor.appendCaller(builder);
        }
        return builder.toString();
    }

    private static void appendCaller(StringBuilder builder) {
        int frames = Constants.getInt((String)DEBUG_RENDER_FRAMES_CONSTANT);
        if (frames <= 0) {
            return;
        }
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        int start = RenderMonitor.skipInternalFrames(stacktrace);
        builder.append(frames == 1 ? " " : "\n\t");
        builder.append("by ");
        StackTraceElement frame = stacktrace[start];
        assert (frame != null);
        RenderMonitor.appendFrame(builder, frame);
        int i = 1;
        int n = stacktrace.length;
        while (i < frames && start + i < n) {
            builder.append("\n\tat ");
            frame = stacktrace[start + i];
            assert (frame != null);
            RenderMonitor.appendFrame(builder, frame);
            ++i;
        }
    }

    private static void appendFrame(StringBuilder builder, StackTraceElement frame) {
        String className = frame.getClassName();
        String methodName = frame.getMethodName();
        className = HierarchyInspector.canonizeClassName(className);
        builder.append(className).append('.').append(methodName).append('(');
        if (Constants.getBoolean((String)ON_S3)) {
            String fileName = frame.getFileName();
            int lineNumber = frame.getLineNumber();
            builder.append(fileName).append(':').append(lineNumber);
        }
        builder.append(')');
    }

    /*
     * Unable to fully structure code
     */
    private static int skipInternalFrames(StackTraceElement[] stacktrace) {
        block11: {
            block10: {
                i = 0;
                if (!RenderMonitor.$assertionsDisabled && !RenderMonitor.frameEquals(Thread.class, "getStackTrace", stacktrace, i)) {
                    throw new AssertionError();
                }
                if (!RenderMonitor.$assertionsDisabled && !RenderMonitor.frameEquals(RenderMonitor.class, "appendCaller", stacktrace, ++i)) {
                    throw new AssertionError();
                }
                if (!RenderMonitor.$assertionsDisabled && !RenderMonitor.frameEquals(RenderMonitor.class, "buildMessage", stacktrace, ++i)) {
                    throw new AssertionError();
                }
                if (!RenderMonitor.$assertionsDisabled && !RenderMonitor.frameEquals(RenderMonitor.class, "onRenderRequested", stacktrace, ++i)) {
                    throw new AssertionError();
                }
                if (!Constants.getBoolean((String)"com.microej.library.microui.onS3")) break block10;
                length = stacktrace.length;
                do {
                    caller = stacktrace[++i];
                    className = caller.getClassName();
                } while ((className = HierarchyInspector.canonizeClassName(className)).startsWith("ej.mwt.") && ++i < length);
                if (!RenderMonitor.$assertionsDisabled && i >= length) {
                    throw new AssertionError((Object)"MWT never request render by itself");
                }
                break block11;
            }
            desktop = Desktop.class.getName();
            widget = Widget.class.getName();
            while (!stacktrace[i].getClassName().equals(desktop)) {
                ++i;
            }
            if (!RenderMonitor.$assertionsDisabled && i >= stacktrace.length) {
                throw new AssertionError();
            }
            if (RenderMonitor.$assertionsDisabled || ++i < stacktrace.length) ** GOTO lbl30
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                ++i;
lbl30:
                // 2 sources

                ** while (stacktrace[i].getClassName().equals((Object)widget))
            }
lbl31:
            // 1 sources

            if (!RenderMonitor.$assertionsDisabled && i >= stacktrace.length) {
                throw new AssertionError();
            }
        }
        return i;
    }

    private static boolean frameEquals(Class<?> clazz, String methodName, StackTraceElement[] stacktrace, int index) {
        assert (index < stacktrace.length);
        StackTraceElement frame = stacktrace[index];
        assert (frame != null);
        if (Constants.getBoolean((String)ON_S3)) {
            assert (clazz.getName().equals(frame.getClassName()));
            assert (methodName.equals(frame.getMethodName()));
        }
        return true;
    }
}

