/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util;

import ej.annotation.Nullable;
import ej.bluetooth.util.Messages;
import ej.bon.ByteArray;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AdvertisementData {
    private static final int MAX_DATA_SIZE = 31;
    private byte flags = (byte)6;
    @Nullable
    private String deviceName = null;
    private short appearance = 0;
    private final Map<Short, byte[]> manufacturerData = new HashMap<Short, byte[]>();

    public byte getFlags() {
        return this.flags;
    }

    @Nullable
    public String getDeviceName() {
        return this.deviceName;
    }

    public short getAppearance() {
        return this.appearance;
    }

    @Nullable
    public byte[] getManufacturerData(int manufacturerId) {
        byte[] data = this.manufacturerData.get((short)manufacturerId);
        return data == null ? null : Arrays.copyOf(data, data.length);
    }

    public void setFlags(int flags) {
        this.flags = (byte)flags;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setAppearance(short appearance) {
        this.appearance = appearance;
    }

    public void addManufacturerData(int manufacturerId, byte[] data) {
        this.manufacturerData.put((short)manufacturerId, Arrays.copyOf(data, data.length));
    }

    public byte[] serialize() {
        byte[] buffer = new byte[31];
        int offset = 0;
        if (this.flags != 0) {
            offset = AdvertisementData.addField(buffer, offset, (byte)1, new byte[]{this.flags});
        }
        if (this.deviceName != null) {
            offset = AdvertisementData.addField(buffer, offset, (byte)9, this.deviceName.getBytes());
        }
        if (this.appearance != 0) {
            byte[] data = new byte[2];
            ByteArray.writeShort((byte[])data, (int)0, (int)this.appearance, (int)0);
            offset = AdvertisementData.addField(buffer, offset, (byte)25, data);
        }
        for (Map.Entry<Short, byte[]> entry : this.manufacturerData.entrySet()) {
            Short id = entry.getKey();
            byte[] value = entry.getValue();
            assert (id != null && value != null);
            byte[] data = new byte[2 + value.length];
            ByteArray.writeShort((byte[])data, (int)0, (int)id.shortValue(), (int)0);
            System.arraycopy(value, 0, data, 2, value.length);
            offset = AdvertisementData.addField(buffer, offset, (byte)-1, data);
        }
        return Arrays.copyOf(buffer, offset);
    }

    private static int addField(byte[] buffer, int offset, byte type, byte[] value) {
        if (offset + 2 + value.length > 31) {
            Messages.getLogger().log('W', "ej.bluetooth.util", -1);
            return offset;
        }
        buffer[offset] = (byte)(1 + value.length);
        buffer[offset + 1] = type;
        System.arraycopy(value, 0, buffer, offset + 2, value.length);
        return offset + 2 + value.length;
    }

    public static AdvertisementData parse(byte[] data) {
        AdvertisementData advertisementData = new AdvertisementData();
        int offset = 0;
        while (offset < data.length) {
            byte length = data[offset];
            if (length == 0 || offset + 1 + length > data.length) break;
            byte type = data[offset + 1];
            byte[] value = new byte[length - 1];
            System.arraycopy(data, offset + 2, value, 0, length - 1);
            AdvertisementData.parseField(type, value, advertisementData);
            offset += 1 + length;
        }
        return advertisementData;
    }

    private static void parseField(byte type, byte[] value, AdvertisementData advertisementData) {
        switch (type) {
            case 1: {
                if (value.length < 1) break;
                advertisementData.setFlags(value[0]);
                break;
            }
            case 8: 
            case 9: {
                advertisementData.setDeviceName(new String(value));
                break;
            }
            case 25: {
                if (value.length != 2) break;
                advertisementData.setAppearance(ByteArray.readShort((byte[])value, (int)0, (int)0));
                break;
            }
            case -1: {
                if (value.length < 2) break;
                short manufacturerId = ByteArray.readShort((byte[])value, (int)0, (int)0);
                byte[] manufacturerData = Arrays.copyOfRange(value, 2, value.length);
                advertisementData.addManufacturerData(manufacturerId, manufacturerData);
            }
        }
    }
}

