/*
 * Decompiled with CFR 0.152.
 */
package com.microej.android.wearos;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.SurfaceHolder;
import androidx.wear.watchface.ListenableCanvasRenderer2;
import androidx.wear.watchface.Renderer;
import androidx.wear.watchface.WatchState;
import androidx.wear.watchface.style.CurrentUserStyleRepository;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.microej.android.MicroEJSupport;
import com.microej.android.application.ApplicationDisplay;
import java.time.ZonedDateTime;
import kotlin.Unit;

class MicroEJCanvasRenderer
extends ListenableCanvasRenderer2<SharedAssets>
implements ApplicationDisplay {
    private static final long FRAME_PERIOD_MS_DEFAULT = 16L;
    private Bitmap flushBitmap;

    public MicroEJCanvasRenderer(SurfaceHolder surfaceHolder, CurrentUserStyleRepository currentUserStyleRepository, WatchState watchState) {
        super(surfaceHolder, currentUserStyleRepository, watchState, 1, 16L);
    }

    public ListenableFuture<SharedAssets> createSharedAssetsFuture() {
        return Futures.immediateFuture((Object)new SharedAssets());
    }

    public ListenableFuture<Unit> initFuture() {
        MicroEJSupport.getApplicationSupport().setDisplay((ApplicationDisplay)this);
        return super.initFuture();
    }

    public void onDestroy() {
        MicroEJSupport.getApplicationSupport().unsetDisplay((ApplicationDisplay)this);
        super.onDestroy();
    }

    public void flush(Bitmap bitmap, Rect bounds) {
        this.flushBitmap = bitmap;
    }

    public void render(Canvas canvas, Rect bounds, ZonedDateTime zonedDateTime, SharedAssets sharedAssets) {
        Bitmap flushBitmap = this.flushBitmap;
        if (flushBitmap != null) {
            canvas.drawBitmap(flushBitmap, bounds, bounds, null);
            MicroEJSupport.getApplicationSupport().onDisplayTearing((ApplicationDisplay)this);
        }
    }

    public void renderHighlightLayer(Canvas canvas, Rect bounds, ZonedDateTime zonedDateTime, SharedAssets sharedAssets) {
    }

    static class SharedAssets
    implements Renderer.SharedAssets {
        SharedAssets() {
        }

        public void onDestroy() {
        }
    }
}

