/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util.services.sps;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.listeners.LocalServiceListener;
import ej.bluetooth.listeners.impl.DefaultLocalServiceListener;
import ej.bluetooth.util.AttributeNotFoundException;
import ej.bluetooth.util.DescriptorHelper;
import ej.bluetooth.util.ServiceHelper;
import ej.bluetooth.util.services.sps.SerialPortConstants;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class SerialPortServer
extends DefaultLocalServiceListener {
    private static final String TX_DESCRIPTION = "TX";
    private static final String RX_DESCRIPTION = "RX";
    private final BluetoothService service;
    private final BluetoothCharacteristic tx;
    private final BluetoothCharacteristic rx;
    private final BluetoothDescriptor txCud;
    private final BluetoothDescriptor txCcc;
    private final BluetoothDescriptor rxCud;
    private final Map<BluetoothConnection, Boolean> txSubscribers;

    public SerialPortServer(BluetoothService service) {
        this.service = service;
        try {
            this.tx = ServiceHelper.getCharacteristic(service, SerialPortConstants.TX_UUID);
            this.rx = ServiceHelper.getCharacteristic(service, SerialPortConstants.RX_UUID);
            this.txCud = ServiceHelper.getDescriptor(this.tx, DescriptorHelper.CUD_UUID);
            this.txCcc = ServiceHelper.getDescriptor(this.tx, DescriptorHelper.CCC_UUID);
            this.rxCud = ServiceHelper.getDescriptor(this.rx, DescriptorHelper.CUD_UUID);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new IllegalArgumentException("Invalid serial port service");
        }
        this.txSubscribers = new WeakHashMap<BluetoothConnection, Boolean>();
    }

    public void start() {
        this.service.setLocalListener((LocalServiceListener)this);
    }

    public void stop() {
        this.service.setLocalListener((LocalServiceListener)new DefaultLocalServiceListener());
    }

    public void sendData(BluetoothConnection connection, byte[] data) {
        if (this.txSubscribers.containsKey(connection)) {
            connection.sendNotification(this.tx, data, false);
        }
    }

    public void onReadRequest(BluetoothConnection connection, BluetoothAttribute attribute) {
        if (attribute == this.txCud) {
            connection.sendReadResponse(attribute, (byte)0, TX_DESCRIPTION.getBytes());
        } else if (attribute == this.rxCud) {
            connection.sendReadResponse(attribute, (byte)0, RX_DESCRIPTION.getBytes());
        } else {
            super.onReadRequest(connection, attribute);
        }
    }

    public void onWriteRequest(BluetoothConnection connection, BluetoothAttribute attribute, byte[] value) {
        if (attribute == this.rx) {
            connection.sendWriteResponse(attribute, (byte)0);
            this.onDataReceived(connection, value);
        } else if (attribute == this.txCcc) {
            if (DescriptorHelper.checkNotificationsEnabled(value)) {
                this.txSubscribers.put(connection, Boolean.TRUE);
            } else {
                this.txSubscribers.remove(connection);
            }
            connection.sendWriteResponse(attribute, (byte)0);
        } else {
            super.onWriteRequest(connection, attribute, value);
        }
    }

    public void onNotificationSent(BluetoothConnection connection, BluetoothCharacteristic characteristic, boolean success) {
        if (characteristic == this.tx) {
            this.onDataSent(connection, success);
        } else {
            super.onNotificationSent(connection, characteristic, success);
        }
    }

    protected abstract void onDataReceived(BluetoothConnection var1, byte[] var2);

    protected abstract void onDataSent(BluetoothConnection var1, boolean var2);
}

