/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util;

import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.BluetoothUuid;
import ej.bluetooth.util.AttributeNotFoundException;
import java.io.PrintStream;

public class ServiceHelper {
    private ServiceHelper() {
    }

    public static int getReadPermission(int securityLevel) {
        switch (securityLevel) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getWritePermission(int securityLevel) {
        switch (securityLevel) {
            case 0: {
                return 8;
            }
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
        }
        throw new IllegalArgumentException();
    }

    public static BluetoothCharacteristic getCharacteristic(BluetoothService service, BluetoothUuid characteristicUuid) throws AttributeNotFoundException {
        int numCharacteristics = service.getNumCharacteristics();
        int i = 0;
        while (i < numCharacteristics) {
            BluetoothCharacteristic characteristic = service.getCharacteristic(i);
            if (characteristic.getUuid().equals((Object)characteristicUuid)) {
                return characteristic;
            }
            ++i;
        }
        throw new AttributeNotFoundException();
    }

    public static BluetoothDescriptor getDescriptor(BluetoothCharacteristic characteristic, BluetoothUuid descriptorUuid) throws AttributeNotFoundException {
        int numDescriptors = characteristic.getNumDescriptors();
        int i = 0;
        while (i < numDescriptors) {
            BluetoothDescriptor descriptor = characteristic.getDescriptor(i);
            if (descriptor.getUuid().equals((Object)descriptorUuid)) {
                return descriptor;
            }
            ++i;
        }
        throw new AttributeNotFoundException();
    }

    public static void printService(BluetoothService service, PrintStream printStream) {
        printStream.println("[SERVICE] " + service.getUuid());
        int numCharacteristics = service.getNumCharacteristics();
        int c = 0;
        while (c < numCharacteristics) {
            BluetoothCharacteristic characteristic = service.getCharacteristic(c);
            String propertiesString = Integer.toHexString(characteristic.getProperties() & 0xFF);
            printStream.println("\t[CHAR] " + characteristic.getUuid() + " P=0x" + propertiesString);
            int numDescriptors = characteristic.getNumDescriptors();
            int d = 0;
            while (d < numDescriptors) {
                BluetoothDescriptor descriptor = characteristic.getDescriptor(d);
                printStream.println("\t\t[DESC] " + descriptor.getUuid());
                ++d;
            }
            ++c;
        }
    }
}

