/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.support;

import ej.hoka.http.support.ParameterizedArgument;

public class ContentType
extends ParameterizedArgument {
    public static final String KEY_CHARSET = "charset";
    private String charset;

    public ContentType() {
    }

    public ContentType(String mimeType) {
        this.argument = mimeType;
    }

    public ContentType(String mimeType, String charset) {
        this(mimeType);
        this.charset = charset;
    }

    @Override
    public void endParse() {
        this.argument = this.argument.toLowerCase().intern();
    }

    @Override
    public StringBuilder generate(StringBuilder sb) {
        super.generate(sb);
        if (this.charset != null) {
            sb.append(';').append(KEY_CHARSET).append('=').append(this.charset);
        }
        return sb;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getMIMEType() {
        return this.argument;
    }

    @Override
    protected void initializeNbParameters(int nbParameters) {
    }

    @Override
    protected void newParameter(int id, int startKey, int stopKey, int startValue, int stopValue) {
        String key = this.currentString.substring(startKey, stopKey).intern();
        String value = this.currentString.substring(startValue, stopValue);
        if (key == KEY_CHARSET) {
            this.charset = value;
        }
    }
}

