/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.hoka.http.Config;
import ej.hoka.http.HaltException;
import ej.hoka.http.HttpRequest;
import ej.hoka.http.HttpResponse;
import ej.hoka.http.MethodNotAllowedException;
import ej.hoka.http.Route;
import ej.hoka.http.RouteHandler;
import ej.hoka.http.RouteNotFoundException;
import ej.hoka.http.encoding.ContentEncoding;
import ej.hoka.http.encoding.EncodingRegistry;
import ej.hoka.http.encoding.HttpUnsupportedEncodingException;
import ej.hoka.http.requesthandler.RequestHandler;
import ej.hoka.http.requesthandler.StaticFilesHandler;
import ej.hoka.log.HokaLogger;
import ej.hoka.tcp.TcpServer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.List;
import javax.net.ServerSocketFactory;

public class HttpServer {
    private static final String HTML_BR = "<br/>";
    private final TcpServer server;
    private final int sessionJobsCount;
    private final RouteHandler routesHandler;
    private final EncodingRegistry encodingRegistry;
    private String notFoundErrorMessage = "";
    private String notFoundErrorContentType = "text/plain";
    private String internalServerErrorMessage = "";
    private String internalServerErrorContentType = "text/plain";
    private Thread[] jobs;
    private final boolean devMode;
    private final boolean strictAcceptEncoding;

    public static HttpServerBuilder builder() {
        return new HttpServerBuilder();
    }

    private HttpServer(int port, int maxSimultaneousConnection, int jobCount, ServerSocketFactory serverSocketFactory, int connectionTimeout, EncodingRegistry encodingRegistry, String apiBase, StaticFilesHandler staticFilesHandler, boolean strictAcceptEncoding, boolean trailingSlashSupport, boolean devMode) {
        this.server = new TcpServer(port, maxSimultaneousConnection, serverSocketFactory, connectionTimeout);
        this.sessionJobsCount = jobCount;
        this.encodingRegistry = encodingRegistry;
        this.routesHandler = new RouteHandler(apiBase, staticFilesHandler, trailingSlashSupport);
        this.strictAcceptEncoding = strictAcceptEncoding;
        this.devMode = devMode;
    }

    public void start() throws IOException {
        this.server.start();
        this.jobs = new Thread[this.sessionJobsCount];
        int i = this.sessionJobsCount - 1;
        while (i >= 0) {
            Thread job;
            this.jobs[i] = job = new Thread(this.newJob(), "HTTP-JOB-" + i);
            job.start();
            --i;
        }
    }

    public void stop() {
        this.server.stop();
        int i = this.jobs.length - 1;
        while (i >= 0) {
            try {
                this.jobs[i].join();
            }
            catch (InterruptedException interruptedException) {}
            --i;
        }
    }

    private Runnable newJob() {
        return new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleConnection(Socket connection) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream(), Config.getInstance().getBufferSize());
                try {
                    try (OutputStream outputStream = connection.getOutputStream();){
                        boolean keepAlive;
                        do {
                            ContentEncoding encodingHandler;
                            HttpResponse response;
                            HttpRequest request;
                            block31: {
                                request = null;
                                response = new HttpResponse();
                                encodingHandler = null;
                                try {
                                    try {
                                        request = new HttpRequest(inputStream, this.encodingRegistry);
                                        if (this.strictAcceptEncoding) {
                                            String accept = request.getHeader("accept-encoding");
                                            encodingHandler = this.encodingRegistry.getAcceptEncodingHandler(accept);
                                            if (this.encodingRegistry.getAcceptEncodingHandler(accept) == null) {
                                                throw new HttpUnsupportedEncodingException("406 Not Acceptable", accept);
                                            }
                                        }
                                        this.routesHandler.process(request, response);
                                        String requestConnectionHeader = request.getHeader("connection");
                                        String responseConnectionHeader = response.getHeader("connection");
                                        boolean bl = "keep-alive".equalsIgnoreCase(requestConnectionHeader) && !"close".equalsIgnoreCase(responseConnectionHeader);
                                    }
                                    catch (HaltException e) {
                                        response.setStatus(e.getStatus());
                                        response.setData(e.getBody());
                                        keepAlive = false;
                                        break block31;
                                    }
                                    catch (MethodNotAllowedException e) {
                                        this.handleMethodNotAllowedError(response, e);
                                        keepAlive = false;
                                        break block31;
                                    }
                                    catch (RouteNotFoundException routeNotFoundException) {
                                        this.handleNotFoundError(response);
                                        keepAlive = false;
                                        break block31;
                                    }
                                    catch (IllegalArgumentException e) {
                                        this.handleError(response, "400 Bad Request", e);
                                        keepAlive = false;
                                        break block31;
                                    }
                                    catch (HttpUnsupportedEncodingException e) {
                                        this.handleError(response, "406 Not Acceptable", e);
                                        keepAlive = false;
                                        break block31;
                                    }
                                    catch (SocketTimeoutException e) {
                                        this.handleError(response, "408 Request Timeout", e);
                                        keepAlive = false;
                                        break block31;
                                    }
                                    catch (IOException e) {
                                        throw e;
                                    }
                                    catch (Throwable e) {
                                        this.handleInternalServerError(response, e);
                                        keepAlive = false;
                                        break block31;
                                    }
                                }
                                catch (Throwable throwable2) {
                                    keepAlive = false;
                                    throw throwable2;
                                }
                                keepAlive = false;
                            }
                            if (keepAlive) {
                                response.addHeader("connection", "keep-alive");
                            } else {
                                response.addHeader("connection", "close");
                            }
                            String msg = this.createResponseLogMsg(request == null ? "" : request.getURI(), response.getStatus(), connection.hashCode(), connection.getInetAddress().getHostAddress());
                            HokaLogger.instance.debug(msg);
                            response.sendResponse(outputStream, encodingHandler, this.encodingRegistry, Config.getInstance().getBufferSize());
                        } while (keepAlive);
                    }
                    if (inputStream == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (inputStream == null) throw throwable;
                    ((InputStream)inputStream).close();
                    throw throwable;
                }
                ((InputStream)inputStream).close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            HokaLogger.instance.error(String.valueOf(connection.hashCode()) + "\t" + connection.getInetAddress().toString(), e);
        }
    }

    private String createResponseLogMsg(String uri, String status, int connection, String address) {
        StringBuilder msg = new StringBuilder();
        msg.append(connection);
        msg.append("\t");
        msg.append(address);
        msg.append("\t");
        msg.append(new Date());
        msg.append("\t");
        msg.append(uri);
        msg.append("\t");
        msg.append(status);
        return msg.toString();
    }

    private void handleMethodNotAllowedError(HttpResponse response, MethodNotAllowedException e) {
        response.setStatus("405 Method Not Allowed");
        response.setData("");
        response.addHeader("allow", e.getAllowHeader());
    }

    private void handleInternalServerError(HttpResponse response, Throwable e) {
        response.setStatus("500 Internal Server Error");
        if (this.devMode) {
            response.setMimeType("text/html");
            response.setData(HttpServer.createHtmlError("500 Internal Server Error", e.getMessage(), e));
        } else {
            response.setMimeType(this.internalServerErrorContentType);
            response.setData(this.internalServerErrorMessage);
        }
    }

    private boolean isKeepAlive(HttpRequest request) {
        return request != null && request.getHeader("connection").equalsIgnoreCase("keep-alive");
    }

    private void handleError(HttpResponse response, String status, Exception e) {
        response.setStatus(status);
        if (this.devMode) {
            response.setMimeType("text/html");
            response.setData(HttpServer.createHtmlError(status, e.getMessage(), e));
        } else {
            response.setData("");
        }
    }

    private void handleNotFoundError(HttpResponse response) {
        response.setStatus("404 Not Found");
        response.setMimeType(this.notFoundErrorContentType);
        if (this.notFoundErrorMessage == null || this.notFoundErrorMessage.isEmpty()) {
            response.setData("");
        } else {
            response.setData(this.notFoundErrorMessage);
        }
    }

    private static String getHtmlExceptionStackTrace(Throwable t) {
        StringBuilder fullMessageBuilder = new StringBuilder();
        String message = t.getMessage();
        if (message != null) {
            fullMessageBuilder.append(message);
            fullMessageBuilder.append(HTML_BR);
        }
        StackTraceElement[] stackTrace = t.getStackTrace();
        int i = 0;
        String className = "java.lang";
        while (i < stackTrace.length && stackTrace[i].getClassName().startsWith(className)) {
            ++i;
        }
        if (i > 0 && i - 1 < stackTrace.length) {
            fullMessageBuilder.append(stackTrace[i - 1].toString()).append(HTML_BR);
        }
        className = HttpServer.class.getName();
        while (i < stackTrace.length && !stackTrace[i].getClassName().equals(className)) {
            fullMessageBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;at ").append(stackTrace[i].toString()).append(HTML_BR);
            ++i;
        }
        return fullMessageBuilder.toString();
    }

    private static String createHtmlError(String status, String msg, Throwable t) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><head><title>");
        buffer.append(status);
        buffer.append("</title></head><body>");
        buffer.append("<h3>").append(status).append("</h3>");
        if (msg != null && !msg.isEmpty()) {
            buffer.append("<p>").append(msg).append("</p>");
        }
        if (t != null) {
            buffer.append("<hr/>");
            buffer.append("<b>Exception:</b>");
            buffer.append("<p>").append(HttpServer.getHtmlExceptionStackTrace(t)).append("</p>");
        }
        buffer.append("</body></html>");
        return buffer.toString();
    }

    public void get(String path, RequestHandler handler) {
        this.get(path, null, handler);
    }

    public void get(String path, String acceptType, RequestHandler handler) {
        this.routesHandler.add(2, path, acceptType, handler);
    }

    public void post(String path, RequestHandler handler) {
        this.post(path, null, handler);
    }

    public void post(String path, String acceptType, RequestHandler handler) {
        this.routesHandler.add(1, path, acceptType, handler);
    }

    public void put(String path, RequestHandler handler) {
        this.put(path, null, handler);
    }

    public void put(String path, String acceptType, RequestHandler handler) {
        this.routesHandler.add(3, path, acceptType, handler);
    }

    public void delete(String path, RequestHandler handler) {
        this.delete(path, null, handler);
    }

    public void delete(String path, String acceptType, RequestHandler handler) {
        this.routesHandler.add(4, path, acceptType, handler);
    }

    public void head(String path, RequestHandler handler) {
        this.head(path, null, handler);
    }

    public void head(String path, String acceptType, RequestHandler handler) {
        this.routesHandler.add(5, path, acceptType, handler);
    }

    public void connect(String path, RequestHandler handler) {
        this.connect(path, null, handler);
    }

    public void connect(String path, String acceptType, RequestHandler handler) {
        this.routesHandler.add(6, path, acceptType, handler);
    }

    public void options(String path, RequestHandler handler) {
        this.options(path, null, handler);
    }

    public void options(String path, String acceptType, RequestHandler handler) {
        this.routesHandler.add(7, path, acceptType, handler);
    }

    public void trace(String path, RequestHandler handler) {
        this.trace(path, null, handler);
    }

    public void trace(String path, String acceptType, RequestHandler handler) {
        this.routesHandler.add(8, path, acceptType, handler);
    }

    public void patch(String path, RequestHandler handler) {
        this.patch(path, null, handler);
    }

    public void patch(String path, String acceptType, RequestHandler handler) {
        this.routesHandler.add(9, path, acceptType, handler);
    }

    public void before(String path, RequestHandler handler) {
        this.routesHandler.add(11, path, handler);
    }

    public void before(RequestHandler handler) {
        this.routesHandler.add(10, "+/*all-routes", handler);
    }

    public void after(String path, RequestHandler handler) {
        this.routesHandler.add(12, path, handler);
    }

    public void after(RequestHandler handler) {
        this.routesHandler.add(13, "+/*all-routes", handler);
    }

    public static final void halt() {
        throw new HaltException();
    }

    public static final void halt(String status) {
        throw new HaltException(status);
    }

    public static final void halt(String status, String body) {
        throw new HaltException(status, body);
    }

    public final void notFoundError(String response) {
        if (response == null) {
            throw new IllegalArgumentException();
        }
        this.notFoundError(response, "text/plain");
    }

    public final void notFoundError(String response, String contentType) {
        if (response == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        this.notFoundErrorMessage = response;
        this.notFoundErrorContentType = contentType;
    }

    public final void internalServerError(String response) {
        if (response == null) {
            throw new IllegalArgumentException();
        }
        this.internalServerError(response, "text/plain");
    }

    public final void internalServerError(String response, String contentType) {
        if (response == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        this.internalServerErrorMessage = response;
        this.internalServerErrorContentType = contentType;
    }

    public final void exception(Class<? extends Exception> exception, RequestHandler handler) {
        this.routesHandler.addExceptionHandler(exception, handler);
    }

    public final List<Route> getRoutes() {
        return this.routesHandler.getRoutes();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public InetAddress getInetAddress() {
        return this.server.getInetAddress();
    }

    /* synthetic */ HttpServer(int n, int n2, int n3, ServerSocketFactory serverSocketFactory, int n4, EncodingRegistry encodingRegistry, String string, StaticFilesHandler staticFilesHandler, boolean bl, boolean bl2, boolean bl3, HttpServer httpServer) {
        this(n, n2, n3, serverSocketFactory, n4, encodingRegistry, string, staticFilesHandler, bl, bl2, bl3);
    }

    static /* synthetic */ TcpServer access$1(HttpServer httpServer) {
        return httpServer.server;
    }

    static /* synthetic */ void access$2(HttpServer httpServer, Socket socket) {
        httpServer.handleConnection(socket);
    }

    public static class HttpServerBuilder {
        private int port = 0;
        private int simultaneousConnections = 1;
        private int workerCount = 1;
        private String apiBase = "";
        private ServerSocketFactory ssf = ServerSocketFactory.getDefault();
        private int connectionTimeout = 60000;
        private EncodingRegistry encodingRegistry = new EncodingRegistry();
        private StaticFilesHandler staticFilesHandler = null;
        private boolean devMode = false;
        private boolean strictAcceptEncoding = false;
        private boolean trailingSlashSupport = false;

        private HttpServerBuilder() {
        }

        public HttpServerBuilder port(int port) throws IllegalArgumentException {
            if (port < 0) {
                throw new IllegalArgumentException();
            }
            this.port = port;
            return this;
        }

        public HttpServerBuilder simultaneousConnections(int simultaneousConnections) throws IllegalArgumentException {
            if (this.simultaneousConnections <= 0) {
                throw new IllegalArgumentException();
            }
            this.simultaneousConnections = simultaneousConnections;
            return this;
        }

        public HttpServerBuilder workerCount(int workerCount) throws IllegalArgumentException {
            if (workerCount <= 0) {
                throw new IllegalArgumentException();
            }
            this.workerCount = workerCount;
            return this;
        }

        public HttpServerBuilder apiBase(String apiBase) throws IllegalArgumentException {
            if (apiBase == null || apiBase.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.apiBase = apiBase;
            return this;
        }

        public HttpServerBuilder secure(ServerSocketFactory ssf) throws IllegalArgumentException {
            if (ssf == null) {
                throw new IllegalArgumentException();
            }
            this.ssf = ssf;
            return this;
        }

        public HttpServerBuilder connectionTimeout(int connectionTimeout) throws IllegalArgumentException {
            if (connectionTimeout < 0) {
                throw new IllegalArgumentException();
            }
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public HttpServerBuilder encodingRegistry(EncodingRegistry encodingRegistry) throws IllegalArgumentException {
            if (encodingRegistry == null) {
                throw new IllegalArgumentException();
            }
            this.encodingRegistry = encodingRegistry;
            return this;
        }

        public HttpServerBuilder withStrictAcceptContentEncoding() {
            this.strictAcceptEncoding = true;
            return this;
        }

        public HttpServerBuilder withTrailingSlashSupport() {
            this.trailingSlashSupport = true;
            return this;
        }

        public HttpServerBuilder staticFilesHandler(StaticFilesHandler handler) throws IllegalArgumentException {
            if (handler == null) {
                throw new IllegalArgumentException();
            }
            this.staticFilesHandler = handler;
            return this;
        }

        public HttpServerBuilder developmentMode() {
            this.devMode = true;
            return this;
        }

        public HttpServer build() {
            return new HttpServer(this.port, this.simultaneousConnections, this.workerCount, this.ssf, this.connectionTimeout, this.encodingRegistry, this.apiBase, this.staticFilesHandler, this.strictAcceptEncoding, this.trailingSlashSupport, this.devMode, null);
        }
    }
}

