/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util.server;

import ej.basictool.ArrayTools;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothDescriptor;
import ej.bluetooth.BluetoothDevice;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.BluetoothUuid;
import ej.bluetooth.callbacks.ServerCallbacks;
import ej.bluetooth.util.server.BasicServerCharacteristic;
import ej.bluetooth.util.server.BasicServerDescriptor;

public class BasicBluetoothServerService
extends BluetoothService
implements ServerCallbacks {
    private BasicServerCharacteristic[] characteristics;

    public BasicBluetoothServerService(BluetoothUuid uuid, BluetoothService.Type type) {
        super(uuid, type);
        this.setServerCallbacks(this);
        this.characteristics = new BasicServerCharacteristic[0];
    }

    public void addCharacteristic(BasicServerCharacteristic characteristic) {
        super.addCharacteristic((BluetoothCharacteristic)characteristic);
        this.characteristics = (BasicServerCharacteristic[])ArrayTools.add((Object[])this.characteristics, (Object)characteristic);
    }

    public void onReadRequest(BluetoothCharacteristic characteristic, BluetoothDevice device) {
        BasicServerCharacteristic[] basicServerCharacteristicArray = this.characteristics;
        int n = this.characteristics.length;
        int n2 = 0;
        while (n2 < n) {
            BasicServerCharacteristic bluetoothCharacteristic = basicServerCharacteristicArray[n2];
            if (characteristic.equals(bluetoothCharacteristic)) {
                bluetoothCharacteristic.onReadRequest(device);
            }
            ++n2;
        }
    }

    public void onWriteRequest(BluetoothCharacteristic characteristic, BluetoothDevice device, byte[] value) {
        BasicServerCharacteristic[] basicServerCharacteristicArray = this.characteristics;
        int n = this.characteristics.length;
        int n2 = 0;
        while (n2 < n) {
            BasicServerCharacteristic bluetoothCharacteristic = basicServerCharacteristicArray[n2];
            if (characteristic.equals(bluetoothCharacteristic)) {
                bluetoothCharacteristic.onWriteRequest(device, value);
            }
            ++n2;
        }
    }

    public void onNotificationSent(BluetoothCharacteristic characteristic, BluetoothDevice device, boolean success) {
    }

    public void onReadRequest(BluetoothDescriptor descriptor, BluetoothDevice device) {
        BasicServerCharacteristic[] basicServerCharacteristicArray = this.characteristics;
        int n = this.characteristics.length;
        int n2 = 0;
        while (n2 < n) {
            BasicServerCharacteristic bluetoothCharacteristic = basicServerCharacteristicArray[n2];
            BasicServerDescriptor[] basicServerDescriptorArray = bluetoothCharacteristic.getServerDescriptors();
            int n3 = basicServerDescriptorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                BasicServerDescriptor bluetoothDescriptor = basicServerDescriptorArray[n4];
                if (descriptor.equals(bluetoothDescriptor)) {
                    bluetoothDescriptor.onReadRequest(device);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void onWriteRequest(BluetoothDescriptor descriptor, BluetoothDevice device, byte[] value) {
        BasicServerCharacteristic[] basicServerCharacteristicArray = this.characteristics;
        int n = this.characteristics.length;
        int n2 = 0;
        while (n2 < n) {
            BasicServerCharacteristic bluetoothCharacteristic = basicServerCharacteristicArray[n2];
            BasicServerDescriptor[] basicServerDescriptorArray = bluetoothCharacteristic.getServerDescriptors();
            int n3 = basicServerDescriptorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                BasicServerDescriptor bluetoothDescriptor = basicServerDescriptorArray[n4];
                if (descriptor.equals(bluetoothDescriptor)) {
                    bluetoothDescriptor.onWriteRequest(device, value);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

