/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util;

import ej.annotation.NonNull;
import ej.annotation.Nullable;

public class BluetoothPayloadUtil {
    public static final byte FLAGS = 1;
    public static final byte SERVICE_UUID16_PARTIAL_LIST = 2;
    public static final byte SERVICE_UUID16_FULL_LIST = 3;
    public static final byte SERVICE_UUID32_PARTIAL_LIST = 4;
    public static final byte SERVICE_UUID32_FULL_LIST = 5;
    public static final byte SERVICE_UUID128_PARTIAL_LIST = 6;
    public static final byte SERVICE_UUID128_FULL_LIST = 7;
    public static final byte SHORTENED_LOCAL_NAME = 8;
    public static final byte COMPLETE_LOCAL_NAME = 9;
    public static final byte TX_POWER_LEVEL = 10;
    public static final byte CONNECTION_INTERVAL = 18;
    public static final byte SOLICITATION_UUID16_LIST = 20;
    public static final byte SOLICITATION_UUID128_LIST = 21;
    public static final byte SERVICE_DATA_UUID16 = 22;
    public static final byte PUBLIC_TARGET_ADDRESS = 23;
    public static final byte RANDOM_TARGET_ADDRESS = 24;
    public static final byte APPEARANCE = 25;
    public static final byte ADVERTISING_INTERVAL = 26;
    public static final byte SOLICITATION_UUID32_LIST = 31;
    public static final byte SERVICE_DATA_UUID32 = 32;
    public static final byte SERVICE_DATA_UUID128 = 33;
    public static final byte URI = 36;
    public static final byte MANUFACTURER_DATA = -1;
    public static final byte FLAG_LE_LIMITED_DISC_MODE = 1;
    public static final byte FLAG_LE_GENERAL_DISC_MODE = 2;
    public static final byte FLAG_BR_EDR_NOT_SUPPORTED = 4;
    public static final byte FLAG_LE_BR_EDR_CONTROLLER = 8;
    public static final byte FLAG_LE_BR_EDR_HOST = 16;
    public static final byte FLAGS_LE_ONLY_LIMITED_DISC_MODE = 5;
    public static final byte FLAGS_LE_ONLY_GENERAL_DISC_MODE = 6;

    private BluetoothPayloadUtil() {
    }

    public static byte[] getBytes(byte type, @NonNull byte[] payload) {
        int index = BluetoothPayloadUtil.getIndex(type, payload);
        if (index > -1) {
            int length = payload[index] - 1;
            byte[] data = new byte[length];
            System.arraycopy(payload, index + 2, data, 0, length);
            return data;
        }
        return null;
    }

    public static String getString(byte type, @NonNull byte[] payload) {
        byte[] data = BluetoothPayloadUtil.getBytes(type, payload);
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    public static Byte getByte(byte type, @NonNull byte[] payload) {
        byte[] data = BluetoothPayloadUtil.getBytes(type, payload);
        if (data == null || data.length != 1) {
            return null;
        }
        return data[0];
    }

    public static byte[] appendPayload(byte type, @NonNull byte[] value, @Nullable byte[] payload) {
        int arrayLength = payload.length + value.length + 2;
        byte[] result = new byte[arrayLength];
        System.arraycopy(payload, 0, result, 0, payload.length);
        result[payload.length] = (byte)(value.length + 1 & 0xFF);
        result[payload.length + 1] = type;
        System.arraycopy(value, 0, result, payload.length + 2, value.length);
        return result;
    }

    public static byte[] removePayload(byte type, byte[] payload) {
        int index = BluetoothPayloadUtil.getIndex(type, payload);
        if (index > -1) {
            int nextPart;
            byte[] newPayload = new byte[payload.length - payload[index] - 1];
            if (index > 0) {
                System.arraycopy(payload, 0, newPayload, 0, index - 1);
            }
            if ((nextPart = index + payload[index] + 1) < payload.length) {
                System.arraycopy(payload, nextPart, newPayload, index, payload.length - nextPart);
            }
            payload = newPayload;
        }
        return payload;
    }

    private static int getIndex(byte type, byte[] payload) {
        int index = -1;
        int i = 0;
        while (i < payload.length) {
            byte length = payload[i];
            int nextIndex = i + length + 1;
            if (length == 0 || nextIndex - 1 >= payload.length) break;
            byte currenTtype = (byte)(payload[i + 1] & 0xFF);
            if (currenTtype == type) {
                index = i;
                break;
            }
            i = nextIndex;
        }
        return index;
    }
}

