/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import ej.bon.ByteArray;
import ej.bon.Constants;
import ej.microui.display.GraphicsContext;
import ej.mwt.Desktop;
import ej.mwt.Widget;
import ej.trace.Tracer;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

class Trace {
    static final String LOG_TRACE_ENABLED_CONSTANT = "ej.mwt.debug.log.trace.enabled";
    static final int CREATE_WIDGET_EVENT = 0;
    static final int CREATE_DESKTOP_EVENT = 1;
    static final int REQUEST_DESKTOP_SHOW_EVENT = 2;
    static final int REQUEST_LAYOUT_EVENT = 3;
    static final int REQUEST_DESKTOP_LAYOUT_EVENT = 4;
    static final int REQUEST_RENDER_EVENT = 5;
    static final int REQUEST_DESKTOP_RENDER_EVENT = 6;
    static final int UPDATE_STYLE_EVENT = 7;
    static final int COMPUTE_SIZE_EVENT = 8;
    static final int LAYOUT_EVENT = 9;
    static final int RENDER_EVENT = 10;
    static final int ON_SHOWN_EVENT = 11;
    static final int ON_HIDDEN_EVENT = 12;
    static final int ON_SHOWN_DESKTOP_EVENT = 13;
    static final int ON_HIDDEN_DESKTOP_EVENT = 14;
    static final int ON_ATTACHED_EVENT = 15;
    static final int ON_DETACHED_EVENT = 16;
    static final int EVENT_COUNT = 64;
    static final Tracer TRACER = new Tracer("MWT", 64);
    private static final Logger LOGGER = Logger.getLogger(Trace.class.getSimpleName());
    private static int currentId = 0;
    private static final Map<Desktop, Integer> desktopsIds = new WeakHashMap<Desktop, Integer>();
    private static final Map<Widget, Integer> widgetsIds = new WeakHashMap<Widget, Integer>();

    private Trace() {
    }

    static int getDesktopId(Desktop desktop) {
        Integer id = desktopsIds.get((Object)desktop);
        if (id != null) {
            return id;
        }
        return -1;
    }

    static void createNewDesktop(Desktop desktop) {
        int id = ++currentId;
        desktopsIds.put(desktop, id);
        TRACER.recordEvent(1, id, ((Object)((Object)desktop)).getClass().hashCode());
        if (Constants.getBoolean((String)LOG_TRACE_ENABLED_CONSTANT)) {
            LOGGER.info("Desktop " + (Object)((Object)desktop) + " gets ID " + id);
        }
    }

    static int getWidgetId(Widget widget) {
        Integer id = widgetsIds.get(widget);
        if (id != null) {
            return id;
        }
        return -1;
    }

    static void createNewWidget(Widget widget) {
        int id = ++currentId;
        widgetsIds.put(widget, id);
        TRACER.recordEvent(0, id, widget.getClass().hashCode());
        if (Constants.getBoolean((String)LOG_TRACE_ENABLED_CONSTANT)) {
            LOGGER.info("Widget " + widget + " gets ID " + id);
        }
    }

    public static int getGraphicsContextId(GraphicsContext gc) {
        return Trace.getInt(gc.getSNIContext(), 0);
    }

    private static int getInt(byte[] sniContext, int offset) {
        if (Constants.getBoolean((String)"com.microej.library.microui.onS3")) {
            return ByteArray.readInt((byte[])sniContext, (int)offset, (int)1);
        }
        return ByteArray.readInt((byte[])sniContext, (int)offset);
    }
}

