/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import com.is2t.microbsp.microui.natives.NSystemDisplay;
import ej.annotation.NonNull;
import ej.microui.display.Display;
import ej.microui.display.GraphicsContext;
import ej.mwt.Desktop;

abstract class RepaintRenderable
implements Runnable {
    private static int PendingRepaint;
    @NonNull
    final Desktop desktop;
    final int x;
    final int y;
    final int width;
    final int height;

    RepaintRenderable(@NonNull Desktop desktop, int x, int y, int width, int height) {
        ++PendingRepaint;
        this.desktop = desktop;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public void run() {
        if (this.desktop != null && this.desktop.isShown()) {
            Display display = this.desktop.getDisplay();
            GraphicsContext g = display.graphics;
            int sd = g.sd;
            try {
                NSystemDisplay.changeBackground((int)sd, (boolean)true);
                this.paint(g);
            }
            finally {
                NSystemDisplay.changeBackground((int)sd, (boolean)false);
                if (--PendingRepaint == 0) {
                    display.executeEventFlush();
                } else {
                    display.addPendingFlush();
                }
            }
        }
    }

    protected abstract void paint(@NonNull GraphicsContext var1);
}

