/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import com.is2t.hil.HIL;
import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.LLVGEngine;
import ej.microvg.Log;
import ej.microvg.MatrixHelper;
import ej.microvg.MicroVGImage;
import ej.microvg.paint.VGColor;
import ej.microvg.paint.VGPaint;

public class LLVGPainter {
    public static final int RETURN_SUCCESS = 0;
    public static final int RESOURCE_CLOSED = -6;
    private static final float[] IDENTITY_MATRIX = MatrixHelper.createIdentity();

    private LLVGPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawPath(byte[] gcArray, byte[] path, int x, int y, float[] matrix, int fillRule, int blend, int color) {
        LLUIDisplay engine;
        LLUIDisplay lLUIDisplay = engine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = engine.mapMicroUIGraphicsContext(gcArray);
            if (gc.requestDrawing()) {
                Log.recordEvent(10, Log.mapGraphicsContext(gc), x, y);
                LLVGEngine drawer = LLVGEngine.Instance;
                drawer.getVGDrawer(gc).drawPath(gc, drawer.mapPath(path), x, y, LLVGPainter.refreshMatrix(matrix), fillRule, blend, new VGColor(color));
                Log.recordEventEnd(10, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawGradient(byte[] gcArray, byte[] path, int x, int y, float[] matrix, int fillRule, int alpha, int blend, int[] gradientData, float[] gradientMatrix) {
        LLUIDisplay engine;
        LLUIDisplay lLUIDisplay = engine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = engine.mapMicroUIGraphicsContext(gcArray);
            if (gc.requestDrawing()) {
                Log.recordEvent(11, Log.mapGraphicsContext(gc), x, y);
                LLVGEngine vgEngine = LLVGEngine.Instance;
                VGPaint p = vgEngine.mapGradient(gradientData, gradientMatrix, matrix, alpha);
                vgEngine.getVGDrawer(gc).drawPath(gc, vgEngine.mapPath(path), x, y, LLVGPainter.refreshMatrix(matrix), fillRule, blend, p);
                Log.recordEventEnd(11, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int drawString(byte[] gcArray, char[] string, int face, float size, float x, float y, float[] matrix, int alpha, int blendMode, float letterSpacing) {
        LLUIDisplay engine;
        int ret = 0;
        LLUIDisplay lLUIDisplay = engine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = engine.mapMicroUIGraphicsContext(gcArray);
            if (gc.requestDrawing()) {
                Log.recordEvent(12, Log.mapGraphicsContext(gc), string.length, (int)x, (int)y);
                ret = LLVGPainter.drawCharArray(gc, string, face, size, x, y, matrix, blendMode, letterSpacing, 0.0f, 0, alpha);
                Log.recordEventEnd(12, 0);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int drawGradientString(byte[] gcArray, char[] string, int face, float size, float x, float y, float[] matrix, int alpha, int blendMode, float letterSpacing, int[] gradientData, float[] gradientMatrix) {
        LLUIDisplay engine;
        int ret = 0;
        LLUIDisplay lLUIDisplay = engine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = engine.mapMicroUIGraphicsContext(gcArray);
            if (gc.requestDrawing()) {
                Log.recordEvent(13, Log.mapGraphicsContext(gc), string.length, (int)x, (int)y);
                ret = LLVGPainter.drawCharArray(gc, string, face, size, x, y, matrix, blendMode, letterSpacing, 0.0f, 0, gradientData, gradientMatrix, alpha);
                Log.recordEventEnd(13, 0);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int drawStringOnCircle(byte[] gcArray, char[] string, int face, float size, int x, int y, float[] matrix, int alpha, int blendMode, float letterSpacing, float radius, int direction) {
        LLUIDisplay engine;
        int ret = 0;
        LLUIDisplay lLUIDisplay = engine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = engine.mapMicroUIGraphicsContext(gcArray);
            if (gc.requestDrawing()) {
                Log.recordEvent(14, Log.mapGraphicsContext(gc), string.length, x, y, (int)radius, direction);
                ret = LLVGPainter.drawCharArray(gc, string, face, size, x, y, matrix, blendMode, letterSpacing, radius, direction, alpha);
                Log.recordEventEnd(14, 0);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int drawGradientStringOnCircle(byte[] gcArray, char[] string, int face, float size, int x, int y, float[] matrix, int alpha, int blendMode, float letterSpacing, float radius, int direction, int[] gradientData, float[] gradientMatrix) {
        LLUIDisplay engine;
        int ret = 0;
        LLUIDisplay lLUIDisplay = engine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = engine.mapMicroUIGraphicsContext(gcArray);
            if (gc.requestDrawing()) {
                Log.recordEvent(15, Log.mapGraphicsContext(gc), string.length, x, y, (int)radius, direction);
                ret = LLVGPainter.drawCharArray(gc, string, face, size, x, y, matrix, blendMode, letterSpacing, radius, direction, gradientData, gradientMatrix, alpha);
                Log.recordEventEnd(15, 0);
            }
        }
        return ret;
    }

    private static int drawCharArray(MicroUIGraphicsContext gc, char[] string, int face, float size, float x, float y, float[] matrix, int blend, float letterSpacing, float radius, int direction, int alpha) {
        VGColor gcColor = new VGColor(VGPaint.applyOpacity(gc.getMicroUIColor(), alpha));
        LLVGPainter.refreshContent(string, 0, string.length);
        return LLVGEngine.Instance.getVGDrawer(gc).drawString(gc, string, face, size, x, y, LLVGPainter.refreshMatrix(matrix), blend, gcColor, letterSpacing, radius, direction);
    }

    private static int drawCharArray(MicroUIGraphicsContext gc, char[] string, int face, float size, float x, float y, float[] matrix, int blend, float letterSpacing, float radius, int direction, int[] gradientData, float[] gradientMatrix, int alpha) {
        LLVGEngine engine = LLVGEngine.Instance;
        VGPaint p = engine.mapGradient(gradientData, gradientMatrix, matrix, alpha);
        LLVGPainter.refreshContent(string, 0, string.length);
        return engine.getVGDrawer(gc).drawString(gc, string, face, size, x, y, LLVGPainter.refreshMatrix(matrix), blend, p, letterSpacing, radius, direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int drawImage(byte[] gcArray, byte[] sniContext, int x, int y, float[] matrix, int alpha, long elapsedTime, float[] colorMatrix) {
        LLUIDisplay engine = LLUIDisplay.Instance;
        int ret = 0;
        LLUIDisplay lLUIDisplay = engine;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = engine.mapMicroUIGraphicsContext(gcArray);
            if (gc.requestDrawing()) {
                LLVGEngine vgEngine = LLVGEngine.Instance;
                MicroVGImage image = vgEngine.mapVectorImage(sniContext);
                Log.recordEvent(16, Log.mapGraphicsContext(gc), Log.mapImage(image), x, y);
                LLVGPainter.refreshContent(colorMatrix);
                matrix = LLVGPainter.refreshMatrix(matrix);
                if (x != 0 || y != 0) {
                    float[] temp = MatrixHelper.create(x, y);
                    MatrixHelper.concatenate(temp, matrix);
                    matrix = temp;
                }
                ret = image == null ? -6 : vgEngine.getVGDrawer(gc).drawImage(gc, vgEngine.mapVectorImage(sniContext), matrix, alpha, elapsedTime, colorMatrix);
                Log.recordEventEnd(16, 0);
            }
        }
        return ret;
    }

    public static float[] refreshMatrix(float[] matrix) {
        if (matrix != null) {
            LLVGPainter.refreshContent(matrix, 0, 9);
            return matrix;
        }
        return IDENTITY_MATRIX;
    }

    public static void refreshContent(Object array) {
        if (array != null) {
            HIL.getInstance().refreshContent(array);
        }
    }

    public static void refreshContent(Object array, int offset, int length) {
        HIL.getInstance().refreshContent(array, offset, length);
    }
}

