/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.impl;

import ej.rcommand.RemoteConnection;
import ej.rcommand.impl.ChunkedInputStream;
import ej.rcommand.impl.LimitedLengthInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamRemoteConnection
implements RemoteConnection {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final byte TYPE_STRING = 83;
    private static final byte TYPE_LONG = 74;
    private static final byte TYPE_BOOLEAN = 90;
    private static final byte TYPE_INT = 73;
    private static final byte TYPE_FLOAT = 70;
    private static final byte TYPE_DOUBLE = 68;
    private static final byte TYPE_BYTE_ARRAY = 65;
    private static final byte TYPE_INPUT_STREAM = 84;
    private static final byte TYPE_END_OF_COMMAND = 69;
    private final DataInputStream in;
    private final DataOutputStream out;
    private boolean closed;
    private boolean locked;
    private boolean eofCommandDetected;

    public StreamRemoteConnection(InputStream is, OutputStream os) {
        this.in = new DataInputStream(is);
        this.out = new DataOutputStream(os);
    }

    private Logger getLogger() {
        return Logger.getLogger(StreamRemoteConnection.class.getName());
    }

    private void logError(IOException e) {
        this.getLogger().log(Level.SEVERE, e.getMessage(), e);
    }

    @Override
    public void startCommand(String command) {
        this.takeLock();
        this.sendString(command);
    }

    @Override
    public void sendString(String s) {
        block2: {
            try {
                this.out.writeByte(83);
                this.out.writeUTF(s);
            }
            catch (IOException e) {
                if (this.closed) break block2;
                this.logError(e);
            }
        }
    }

    @Override
    public void sendLong(long l) {
        block2: {
            try {
                this.out.writeByte(74);
                this.out.writeLong(l);
            }
            catch (IOException e) {
                if (this.closed) break block2;
                this.logError(e);
            }
        }
    }

    @Override
    public void sendInt(int i) {
        block2: {
            try {
                this.out.writeByte(73);
                this.out.writeInt(i);
            }
            catch (IOException e) {
                if (this.closed) break block2;
                this.logError(e);
            }
        }
    }

    @Override
    public void sendFloat(float f) {
        block2: {
            try {
                this.out.writeByte(70);
                this.out.writeFloat(f);
            }
            catch (IOException e) {
                if (this.closed) break block2;
                this.logError(e);
            }
        }
    }

    @Override
    public void sendDouble(double d) {
        block2: {
            try {
                this.out.writeByte(68);
                this.out.writeDouble(d);
            }
            catch (IOException e) {
                if (this.closed) break block2;
                this.logError(e);
            }
        }
    }

    @Override
    public void sendBoolean(boolean b) {
        block2: {
            try {
                this.out.writeByte(90);
                this.out.writeBoolean(b);
            }
            catch (IOException e) {
                if (this.closed) break block2;
                this.logError(e);
            }
        }
    }

    @Override
    public void sendByteArray(byte[] a) {
        block2: {
            try {
                this.out.writeByte(65);
                this.out.writeInt(a.length);
                this.out.write(a);
            }
            catch (IOException e) {
                if (this.closed) break block2;
                this.logError(e);
            }
        }
    }

    @Override
    public void sendByteArrayAsInputStream(InputStream is) {
        block3: {
            try {
                int count;
                this.out.writeByte(65);
                int length = is.available();
                this.out.writeInt(length);
                byte[] buffer = new byte[64];
                for (int index = 0; index != length; index += count) {
                    count = is.read(buffer);
                    this.out.write(buffer, 0, count);
                }
            }
            catch (IOException e) {
                if (this.closed) break block3;
                this.logError(e);
            }
        }
    }

    @Override
    public void flushCommand() {
        block2: {
            try {
                this.out.writeByte(69);
                this.out.flush();
            }
            catch (IOException e) {
                if (this.closed) break block2;
                this.logError(e);
            }
        }
        this.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void takeLock() {
        StreamRemoteConnection streamRemoteConnection = this;
        synchronized (streamRemoteConnection) {
            while (this.locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock() {
        StreamRemoteConnection streamRemoteConnection = this;
        synchronized (streamRemoteConnection) {
            this.locked = false;
            this.notifyAll();
        }
    }

    @Override
    public String readString() throws IOException {
        try {
            this.checkType((byte)83);
            return this.in.readUTF();
        }
        catch (IOException e) {
            if (!this.closed) {
                this.logError(e);
                throw e;
            }
            return "";
        }
    }

    @Override
    public String readCommand() throws IOException {
        try {
            this.checkType((byte)83);
            return this.in.readUTF();
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException e) {
            if (!this.closed) {
                this.logError(e);
                throw e;
            }
            return "";
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            this.checkType((byte)74);
            return this.in.readLong();
        }
        catch (IOException e) {
            if (!this.closed) {
                this.logError(e);
                throw e;
            }
            return -1L;
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            this.checkType((byte)73);
            return this.in.readInt();
        }
        catch (IOException e) {
            if (!this.closed) {
                this.logError(e);
                throw e;
            }
            return -1;
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            this.checkType((byte)70);
            return this.in.readFloat();
        }
        catch (IOException e) {
            if (!this.closed) {
                this.logError(e);
                throw e;
            }
            return -1.0f;
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            this.checkType((byte)68);
            return this.in.readDouble();
        }
        catch (IOException e) {
            if (!this.closed) {
                this.logError(e);
                throw e;
            }
            return -1.0;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            this.checkType((byte)90);
            return this.in.readBoolean();
        }
        catch (IOException e) {
            if (!this.closed) {
                this.logError(e);
                throw e;
            }
            return false;
        }
    }

    @Override
    public byte[] readByteArray() throws IOException {
        try {
            this.checkType((byte)65);
            return this.readByteArrayIntern();
        }
        catch (Throwable e) {
            if (!this.closed) {
                this.getLogger().log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            return new byte[0];
        }
    }

    @Override
    public InputStream readByteArrayAsInputStream() throws IOException {
        try {
            this.checkType((byte)65);
            int length = this.in.readInt();
            return new LimitedLengthInputStream(this.in, length);
        }
        catch (Throwable e) {
            if (!this.closed) {
                this.getLogger().log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            return new LimitedLengthInputStream();
        }
    }

    private byte[] readByteArrayIntern() throws IOException {
        int length = this.in.readInt();
        if (length < 0) {
            return new byte[0];
        }
        try {
            byte[] a = new byte[length];
            this.in.readFully(a);
            return a;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    @Override
    public List<Object> readParameters() throws IOException {
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            while (true) {
                Object param;
                byte type = this.in.readByte();
                switch (type) {
                    case 65: {
                        param = this.readByteArrayIntern();
                        break;
                    }
                    case 83: {
                        param = this.in.readUTF();
                        break;
                    }
                    case 74: {
                        long l = this.in.readLong();
                        param = l;
                        break;
                    }
                    case 90: {
                        boolean b = this.in.readBoolean();
                        param = b;
                        break;
                    }
                    case 73: {
                        int i = this.in.readInt();
                        param = i;
                        break;
                    }
                    case 70: {
                        float f = this.in.readFloat();
                        param = Float.valueOf(f);
                        break;
                    }
                    case 68: {
                        double d = this.in.readDouble();
                        param = d;
                        break;
                    }
                    case 69: {
                        this.eofCommandDetected = true;
                        return params;
                    }
                    default: {
                        throw new InternalError("Invalid parameter type.");
                    }
                }
                params.add(param);
            }
        }
        catch (IOException e) {
            if (!this.closed) {
                this.logError(e);
                throw e;
            }
            return params;
        }
    }

    @Override
    public void sendParams(List<Object> params) {
        for (Object param : params) {
            if (param.getClass().isArray()) {
                byte[] array = (byte[])param;
                this.sendByteArray(array);
                continue;
            }
            if (param instanceof String) {
                String s = (String)param;
                this.sendString(s);
                continue;
            }
            if (param instanceof Long) {
                Long l = (Long)param;
                this.sendLong(l);
                continue;
            }
            if (param instanceof Integer) {
                Integer i = (Integer)param;
                this.sendInt(i);
                continue;
            }
            if (param instanceof Float) {
                Float f = (Float)param;
                this.sendFloat(f.floatValue());
                continue;
            }
            if (param instanceof Double) {
                Double d = (Double)param;
                this.sendDouble(d);
                continue;
            }
            if (param instanceof Boolean) {
                Boolean b = (Boolean)param;
                this.sendBoolean(b);
                continue;
            }
            throw new InternalError("Invalid parameter type: " + param.getClass());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void skipParameters() throws IOException {
        if (this.eofCommandDetected) {
            this.eofCommandDetected = false;
            return;
        }
        boolean errorDetected = false;
        try {
            block15: while (true) {
                byte type = this.in.readByte();
                switch (type) {
                    case 65: {
                        InputStream stream = this.readByteArrayAsInputStream();
                        byte[] chuncks = new byte[LimitedLengthInputStream.CHUNCKS_SIZE];
                        while (true) {
                            if (stream.read(chuncks) == -1) continue block15;
                        }
                    }
                    case 83: {
                        try {
                            this.in.readUTF();
                        }
                        catch (UTFDataFormatException | Error e) {
                            if (errorDetected) continue block15;
                            this.getLogger().severe("Invalid UTF string.");
                            errorDetected = true;
                        }
                        continue block15;
                    }
                    case 74: {
                        this.in.readLong();
                        continue block15;
                    }
                    case 70: {
                        this.in.readFloat();
                        continue block15;
                    }
                    case 68: {
                        this.in.readDouble();
                        continue block15;
                    }
                    case 90: {
                        this.in.readBoolean();
                        continue block15;
                    }
                    case 73: {
                        this.in.readInt();
                        continue block15;
                    }
                    case 84: {
                        int chunkSize = this.in.readInt();
                        while (true) {
                            if (chunkSize == 0) continue block15;
                            while (chunkSize > 0) {
                                chunkSize = (int)((long)chunkSize - this.in.skip(chunkSize));
                            }
                            chunkSize = this.in.readInt();
                        }
                    }
                    case 69: {
                        if (errorDetected) {
                            this.getLogger().warning("Invalid frame skipped");
                        }
                        return;
                    }
                }
                if (errorDetected) continue;
                this.getLogger().severe("Invalid parameter type (0x" + Integer.toHexString(type & 0xFF) + ").");
                errorDetected = true;
            }
        }
        catch (IOException e) {
            if (!this.closed) {
                this.logError(e);
                throw e;
            }
            return;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkType(byte expected) throws IOException {
        byte type = this.in.readByte();
        if (type != expected) {
            throw new IllegalArgumentException("Invalid parameter type: 0x" + Integer.toHexString(type) + " expected 0x" + Integer.toHexString(expected));
        }
    }

    @Override
    public void sendInputStream(InputStream is) {
        block3: {
            try {
                this.out.writeByte(84);
                byte[] buffer = new byte[4096];
                int read = is.read(buffer);
                while (read != -1) {
                    this.out.writeInt(read);
                    this.out.write(buffer, 0, read);
                    this.out.flush();
                    read = is.read(buffer);
                }
                this.out.writeInt(0);
            }
            catch (IOException e) {
                if (this.closed) break block3;
                this.logError(e);
            }
        }
    }

    @Override
    public InputStream readInputStream() throws IOException {
        this.checkType((byte)84);
        return new ChunkedInputStream(this.in);
    }
}

