/*
 * Decompiled with CFR 0.152.
 */
package ej.net.util.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SslContextBuilder {
    private static final String TLS_VERSION_1_2 = "TLSv1.2";
    private static final String CERT_TYPE = "X509";
    private static final String KEYSTORE_TYPE = "PKCS12";
    private final KeyStore trustStore = SslContextBuilder.createTrustStoreInstance();
    private final KeyStore keyStore = SslContextBuilder.createKeyStoreInstance();
    private int aliasId = 0;

    public void addServerCertificate(InputStream certificate) throws GeneralSecurityException {
        Certificate cert = SslContextBuilder.generateCertificate(certificate);
        this.trustStore.setCertificateEntry(this.getNewAlias(), cert);
    }

    public void addServerCertificate(String certificatePath) throws GeneralSecurityException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream certificate = this.loadResource(certificatePath);){
            this.addServerCertificate(certificate);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addClientKey(byte[] privateKey, InputStream certificate, InputStream ... certificationChain) throws GeneralSecurityException {
        Certificate[] certChain;
        Certificate cert = SslContextBuilder.generateCertificate(certificate);
        if (certificationChain == null) {
            certChain = new Certificate[]{cert};
        } else {
            certChain = new Certificate[1 + certificationChain.length];
            certChain[0] = cert;
            int i = 0;
            while (i < certificationChain.length) {
                certChain[i + 1] = SslContextBuilder.generateCertificate(certificationChain[i]);
                ++i;
            }
        }
        this.keyStore.setKeyEntry(this.getNewAlias(), privateKey, certChain);
    }

    public void addClientKey(byte[] privateKey, InputStream certificate) throws GeneralSecurityException {
        InputStream[] noChain = null;
        this.addClientKey(privateKey, certificate, noChain);
    }

    public void addClientKey(InputStream privateKey, InputStream certificate, InputStream ... certificationChain) throws IOException, GeneralSecurityException {
        this.addClientKey(SslContextBuilder.readInputStream(privateKey), certificate, certificationChain);
    }

    public void addClientKey(InputStream privateKey, InputStream certificate) throws IOException, GeneralSecurityException {
        InputStream[] noChain = null;
        this.addClientKey(SslContextBuilder.readInputStream(privateKey), certificate, noChain);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addClientKey(String privateKeyPath, String certificatePath, String ... certificationChainPaths) throws IOException, GeneralSecurityException {
        int i;
        InputStream[] certificationChain;
        block21: {
            certificationChain = null;
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                InputStream privateKey = this.loadResource(privateKeyPath);
                try {
                    try (InputStream certificate = this.loadResource(certificatePath);){
                        if (certificationChainPaths != null) {
                            certificationChain = new InputStream[certificationChainPaths.length];
                            int i2 = 0;
                            while (i2 < certificationChainPaths.length) {
                                certificationChain[i2] = this.loadResource(certificationChainPaths[i2]);
                                ++i2;
                            }
                        }
                        this.addClientKey(privateKey, certificate, certificationChain);
                    }
                    if (privateKey == null) break block21;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (privateKey == null) throw throwable;
                    privateKey.close();
                    throw throwable;
                }
                privateKey.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
            finally {
                if (certificationChain == null) return;
                i = 0;
                break;
            }
        }
        while (i < certificationChain.length) {
            if (certificationChain[i] != null) {
                certificationChain[i].close();
            }
            ++i;
        }
        return;
    }

    public SSLContext build() throws GeneralSecurityException {
        TrustManagerFactory tm = TrustManagerFactory.getInstance(CERT_TYPE);
        tm.init(this.trustStore);
        TrustManager[] trustManagers = tm.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance(TLS_VERSION_1_2);
        sslContext.init(null, trustManagers, null);
        return sslContext;
    }

    public SSLContext build(String keyStorePassword) throws GeneralSecurityException {
        TrustManagerFactory tm = TrustManagerFactory.getInstance(CERT_TYPE);
        tm.init(this.trustStore);
        TrustManager[] trustManagers = tm.getTrustManagers();
        KeyManagerFactory km = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        km.init(this.keyStore, keyStorePassword.toCharArray());
        KeyManager[] keyManagers = km.getKeyManagers();
        SSLContext sslContext = SSLContext.getInstance(TLS_VERSION_1_2);
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private String getNewAlias() {
        return Integer.toString(this.aliasId++);
    }

    private static KeyStore createTrustStoreInstance() throws GeneralSecurityException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            trustStore.load(null, null);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        return trustStore;
    }

    private static KeyStore createKeyStoreInstance() throws GeneralSecurityException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        }
        catch (KeyStoreException keyStoreException) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        try {
            keyStore.load(null, null);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        return keyStore;
    }

    private static Certificate generateCertificate(InputStream inputStream) throws GeneralSecurityException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE);
        return certificateFactory.generateCertificate(inputStream);
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        int bytesRead;
        byte[] data = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        while ((bytesRead = inputStream.read(data)) > 0) {
            out.write(data, 0, bytesRead);
        }
        return out.toByteArray();
    }

    private InputStream loadResource(String path) {
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is == null) {
            throw new IllegalArgumentException("Cannot load " + path);
        }
        return is;
    }
}

