/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothConnection;
import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;
import java.io.IOException;

public class SendExecuteWriteResponseEndpoint
implements Endpoint {
    private final BluetoothController controller;
    private short connHandle;
    private short attributeHandle;
    private byte status;

    public SendExecuteWriteResponseEndpoint(BluetoothController controller) {
        this.controller = controller;
    }

    public String getName() {
        return "bluetooth_send_execute_write_response";
    }

    public void readRequestBody(CommandReader reader) throws IOException {
        this.connHandle = (short)reader.readInt();
        this.attributeHandle = (short)reader.readInt();
        this.status = (byte)reader.readInt();
    }

    public void writeResponseBody(CommandSender sender) throws IOException {
        BluetoothConnection connection = this.controller.getConnection(this.connHandle);
        BluetoothAttribute attribute = this.controller.getLocalAttribute(this.attributeHandle);
        if (connection != null && attribute != null && connection.sendExecuteWriteResponse(attribute, this.status)) {
            sender.sendInt(0);
        } else {
            sender.sendInt(1);
        }
    }
}

