/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Date;

public class SimpleDateFormat
extends DateFormat {
    private static final int HOUR_AT_MIDNIGHT = 24;
    private static final int HOUR_AT_MIDDAY = 12;
    private static final String EMPTY_STRING = "";
    private static final char ERA_DESIGNATOR = 'G';
    private static final char YEAR = 'y';
    private static final char WEEK_YEAR = 'Y';
    private static final char MONTH = 'M';
    private static final char WEEK_OF_YEAR = 'w';
    private static final char WEEK_OF_MONTH = 'W';
    private static final char DAY_OF_YEAR = 'D';
    private static final char DAY_OF_MONTH = 'd';
    private static final char DAY_OF_WEEK_IN_MONTH = 'F';
    private static final char DAY_NAME_IN_WEEK = 'E';
    private static final char DAY_NUMBER_OF_WEEK = 'u';
    private static final char AM_PM = 'a';
    private static final char HOUR_OF_DAY_0 = 'H';
    private static final char HOUR_OF_DAY_1 = 'k';
    private static final char HOUR_0 = 'K';
    private static final char HOUR_1 = 'h';
    private static final char MINUTE_IN_HOUR = 'm';
    private static final char SECOND_IN_MINUTE = 's';
    private static final char MILLISECOND = 'S';
    private static final char STRING = '\'';
    private DateFormatSymbols symbols;
    private String pattern;
    private String[] compilePatterns;

    public SimpleDateFormat() {
        this(EMPTY_STRING, DateFormatSymbols.getInstance());
    }

    public SimpleDateFormat(String pattern) {
        this(pattern, DateFormatSymbols.getInstance());
    }

    public SimpleDateFormat(String pattern, DateFormatSymbols formatSymbols) {
        if (pattern == null || formatSymbols == null) {
            throw new NullPointerException();
        }
        this.applyPattern(pattern);
        this.symbols = formatSymbols;
    }

    @Override
    public String format(Date date) {
        this.calendar.setTime(date);
        StringBuilder builder = new StringBuilder();
        String[] stringArray = this.compilePatterns;
        int n = this.compilePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.addPattern(builder, pattern);
            ++n2;
        }
        return builder.toString();
    }

    private void addPattern(StringBuilder builder, String pattern) {
        char field = pattern.charAt(0);
        switch (field) {
            case 'G': {
                this.addERA(builder, pattern);
                break;
            }
            case 'y': {
                this.addYear(builder, pattern);
                break;
            }
            case 'Y': {
                this.addWeekYear(builder, pattern);
                break;
            }
            case 'M': {
                this.addMonth(builder, pattern);
                break;
            }
            case 'w': {
                this.addCalandarValue(3, builder, pattern);
                break;
            }
            case 'W': {
                this.addCalandarValue(4, builder, pattern);
                break;
            }
            case 'D': {
                this.addCalandarValue(6, builder, pattern);
                break;
            }
            case 'd': {
                this.addCalandarValue(5, builder, pattern);
                break;
            }
            case 'F': {
                this.addCalandarValue(8, builder, pattern);
                break;
            }
            case 'E': {
                this.addDay(builder, pattern);
                break;
            }
            case 'u': {
                this.addDayNumber(builder, pattern);
                break;
            }
            case 'a': {
                this.addAMPM(builder, pattern);
                break;
            }
            case 'H': {
                this.addHourOfDay(builder, pattern, false);
                break;
            }
            case 'k': {
                this.addHourOfDay(builder, pattern, true);
                break;
            }
            case 'K': {
                this.addHour(builder, pattern, false);
                break;
            }
            case 'h': {
                this.addHour(builder, pattern, true);
                break;
            }
            case 'm': {
                this.addCalandarValue(12, builder, pattern);
                break;
            }
            case 's': {
                this.addCalandarValue(13, builder, pattern);
                break;
            }
            case 'S': {
                this.addCalandarValue(14, builder, pattern);
                break;
            }
            case '\'': {
                this.addString(builder, pattern);
                break;
            }
            default: {
                builder.append(pattern);
            }
        }
    }

    private void addString(StringBuilder builder, String pattern) {
        if (pattern.length() <= 2) {
            builder.append('\'');
        } else {
            pattern = pattern.substring(1, pattern.length() - 1);
            builder.append(pattern.replace(String.valueOf(String.valueOf('\'')) + '\'', String.valueOf('\'')));
        }
    }

    private void addHour(StringBuilder builder, String pattern, boolean startAtOne) {
        int hour = this.calendar.get(10);
        if (startAtOne && hour == 0) {
            hour = 12;
        }
        builder.append(SimpleDateFormat.formatNum(hour, pattern.length(), false));
    }

    private void addHourOfDay(StringBuilder builder, String pattern, boolean startAtOne) {
        int hour = this.calendar.get(11);
        if (startAtOne && hour == 0) {
            hour = 24;
        }
        builder.append(SimpleDateFormat.formatNum(hour, pattern.length(), false));
    }

    private void addCalandarValue(int field, StringBuilder builder, String pattern) {
        int value = this.calendar.get(field);
        builder.append(SimpleDateFormat.formatNum(value, pattern.length(), false));
    }

    private void addAMPM(StringBuilder builder, String pattern) {
        int position = this.calendar.get(9) == 0 ? 0 : 1;
        builder.append(this.symbols.getAmPmString(position));
    }

    private void addDay(StringBuilder builder, String pattern) {
        int day = this.calendar.get(7) - 1;
        String dayString = pattern.length() <= 3 ? this.symbols.getShortWeekday(day) : this.symbols.getWeekday(day);
        builder.append(dayString);
    }

    private void addDayNumber(StringBuilder builder, String pattern) {
        int day = this.calendar.get(7) - 1;
        if (day == 0) {
            day = 7;
        }
        builder.append(SimpleDateFormat.formatNum(day, pattern.length(), false));
    }

    private void addMonth(StringBuilder builder, String pattern) {
        int month = this.calendar.get(2);
        String monthString = pattern.length() == 3 ? this.symbols.getShortMonth(month) : (pattern.length() > 3 ? this.symbols.getMonth(month) : SimpleDateFormat.formatNum(month + 1, pattern.length(), false));
        builder.append(monthString);
    }

    private void addYear(StringBuilder builder, String pattern) {
        int year = this.calendar.get(1);
        builder.append(SimpleDateFormat.formatNum(year, pattern.length(), pattern.length() == 2));
    }

    private void addWeekYear(StringBuilder builder, String pattern) {
        int year = this.calendar.get(1);
        int day = this.calendar.get(6);
        int week = this.calendar.get(3);
        if (day < 7 && week > 1) {
            --year;
        } else if (day > 7 && week == 1) {
            ++year;
        }
        builder.append(SimpleDateFormat.formatNum(year, pattern.length(), pattern.length() == 2));
    }

    private void addERA(StringBuilder builder, String pattern) {
        String era = this.calendar.get(1) < 0 ? this.symbols.getEra(0) : this.symbols.getEra(1);
        builder.append(era);
    }

    /*
     * Unable to fully structure code
     */
    private static String formatNum(int value, int length, boolean truncate) {
        block2: {
            number = Integer.toString(Math.abs(value));
            builder = new StringBuilder();
            stringLength = number.length();
            if (stringLength <= length || !truncate) ** GOTO lbl10
            builder.append(number.substring(stringLength - length, stringLength));
            break block2;
lbl-1000:
            // 1 sources

            {
                builder.append('0');
lbl10:
                // 2 sources

                ** while (builder.length() + stringLength < length)
            }
lbl11:
            // 1 sources

            builder.append(number);
        }
        if (value < 0) {
            builder.insert(0, '-');
        }
        return builder.toString();
    }

    private static String getNextPattern(String pattern, int parsePosition) throws IllegalArgumentException {
        int position;
        block12: {
            int size = pattern.length();
            if (parsePosition >= size) {
                return null;
            }
            position = parsePosition + 1;
            char firstChar = pattern.charAt(parsePosition);
            if (firstChar == '\'') {
                boolean findEnd = false;
                while (true) {
                    if (position == size) {
                        if (!findEnd) {
                            throw new IllegalArgumentException();
                        }
                        break block12;
                    }
                    if (pattern.charAt(position) == '\'') {
                        findEnd = !findEnd;
                    } else if (findEnd) break block12;
                    ++position;
                }
            }
            if (position < size && pattern.charAt(position) == firstChar) {
                while (position < size && pattern.charAt(position) == firstChar) {
                    ++position;
                }
            } else {
                return Character.toString(pattern.charAt(parsePosition));
            }
        }
        return pattern.substring(parsePosition, position);
    }

    public String toPattern() {
        return this.pattern;
    }

    public void applyPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.compilePatterns();
    }

    private void compilePatterns() throws IllegalArgumentException {
        ArrayList<String> strings = new ArrayList<String>();
        int parsePosition = 0;
        String nextPattern = SimpleDateFormat.getNextPattern(this.pattern, parsePosition);
        while (nextPattern != null) {
            strings.add(nextPattern);
            nextPattern = SimpleDateFormat.getNextPattern(this.pattern, parsePosition += nextPattern.length());
        }
        String[] compilePatterns = new String[strings.size()];
        strings.toArray(compilePatterns);
        this.compilePatterns = compilePatterns;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.symbols;
    }

    public void setDateFormatSymbols(DateFormatSymbols newFormatSymbols) {
        if (newFormatSymbols == null) {
            throw new NullPointerException();
        }
        this.symbols = newFormatSymbols;
    }
}

