/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.impl;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private final DataInputStream in;
    private byte[] chunk;
    private int position;
    private boolean eof;

    public ChunkedInputStream(DataInputStream in) {
        this.in = in;
        this.chunk = new byte[0];
    }

    @Override
    public int available() throws IOException {
        return this.chunk.length - this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L || this.eof) {
            return 0L;
        }
        if (this.position >= this.chunk.length) {
            this.fillBuffer();
            if (this.eof) {
                return 0L;
            }
        }
        long bytesSkipped = Math.min((long)(this.chunk.length - this.position), n);
        this.position = (int)((long)this.position + bytesSkipped);
        return bytesSkipped;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.position >= this.chunk.length) {
            this.fillBuffer();
            if (this.eof) {
                return -1;
            }
        }
        return this.chunk[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.eof) {
            return -1;
        }
        if (this.position >= this.chunk.length) {
            this.fillBuffer();
            if (this.eof) {
                return -1;
            }
        }
        int bytesRead = Math.min(this.chunk.length - this.position, len);
        System.arraycopy(this.chunk, this.position, b, off, bytesRead);
        this.position += bytesRead;
        return bytesRead;
    }

    /*
     * Unable to fully structure code
     */
    private void fillBuffer() throws IOException {
        chunkSize = this.in.readInt();
        if (chunkSize == 0) {
            this.eof = true;
            return;
        }
        if (this.chunk.length != chunkSize) {
            this.chunk = new byte[chunkSize];
        }
        if ((chunkSize = this.in.read(this.chunk)) != -1) ** GOTO lbl13
        throw new EOFException();
lbl-1000:
        // 1 sources

        {
            nbRead = this.in.read(this.chunk, chunkSize, this.chunk.length - chunkSize);
            if (nbRead == -1) {
                throw new EOFException();
            }
            chunkSize += nbRead;
lbl13:
            // 2 sources

            ** while (chunkSize < this.chunk.length)
        }
lbl14:
        // 1 sources

        if (chunkSize != this.chunk.length) {
            throw new IOException("chunkSize != this.chunk.length");
        }
        this.position = 0;
    }

    @Override
    public void close() throws IOException {
        this.eof = true;
    }
}

