/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image;

import ej.microvg.MatrixHelper;
import ej.microvg.image.ImageDecoder;
import ej.microvg.image.pathdata.PathData;
import ej.microvg.image.pathdata.SingleArrayPathData;
import ej.microvg.image.pathdata.SingleArrayPathDataFP32;
import ej.microvg.image.pathdata.SingleArrayPathDataS16;
import ej.microvg.image.pathdata.SingleArrayPathDataS32;
import ej.microvg.image.pathdata.SingleArrayPathDataS8;
import ej.microvg.paint.LinearGradient;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class VgliteImageDecoder
implements ImageDecoder {
    private static final int VG_LITE_S8 = 0;
    private static final int VG_LITE_S16 = 1;
    private static final int VG_LITE_S32 = 2;
    private static final int VG_LITE_FP32 = 3;
    private static final int CMD_CLOSE = 0;
    private static final int CMD_MOVE = 2;
    private static final int CMD_MOVE_REL = 3;
    private static final int CMD_LINE = 4;
    private static final int CMD_LINE_REL = 5;
    private static final int CMD_QUAD = 6;
    private static final int CMD_QUAD_REL = 7;
    private static final int CMD_CUBIC = 8;
    private static final int CMD_CUBIC_REL = 9;
    private static final int VG_LITE_FILL_NON_ZERO = 0;
    private static final int VG_LITE_FILL_EVEN_ODD = 1;

    @Override
    public PathData decodePath(ByteBuffer is) {
        SingleArrayPathData parser;
        is.getFloat();
        is.getFloat();
        is.getFloat();
        is.getFloat();
        int length = is.getInt();
        byte format = is.get();
        is.get();
        is.get();
        is.get();
        ByteBuffer buffer = ByteBuffer.wrap(is.array(), is.position(), length).order(ByteOrder.LITTLE_ENDIAN);
        switch (format) {
            case 0: {
                parser = new SingleArrayPathDataS8(buffer);
                break;
            }
            case 1: {
                parser = new SingleArrayPathDataS16(buffer);
                break;
            }
            case 2: {
                parser = new SingleArrayPathDataS32(buffer);
                break;
            }
            case 3: {
                parser = new SingleArrayPathDataFP32(buffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown format: " + format);
            }
        }
        return parser;
    }

    @Override
    public LinearGradient decodeGradient(ByteBuffer is) {
        Color[] colors = new Color[16];
        int i = 0;
        while (i < 16) {
            colors[i] = new Color(is.getInt(), true);
            ++i;
        }
        int count = is.getInt();
        float[] positions = new float[16];
        int i2 = 0;
        while (i2 < 16) {
            double pos = is.getInt();
            positions[i2] = (float)(pos /= 255.0);
            ++i2;
        }
        float[] matrix = VgliteImageDecoder.getMatrix(is);
        MatrixHelper.scale(matrix, 256.0f, 1.0f);
        return new LinearGradient(Arrays.copyOf(colors, count), Arrays.copyOf(positions, count), matrix);
    }

    @Override
    public int decodeCommand(int encodedCommand) {
        switch (encodedCommand) {
            default: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: 
        }
        return 8;
    }

    @Override
    public int decodeFillRule(int rule) {
        return 1 == rule ? 1 : 0;
    }

    private static float[] getMatrix(ByteBuffer is) {
        float[] matrix = MatrixHelper.create();
        int i = 0;
        while (i < matrix.length) {
            matrix[i] = is.getFloat();
            ++i;
        }
        return matrix;
    }
}

