/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import ej.annotation.Nullable;
import ej.bon.ResourceBuffer;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;

public class TzdbZoneRulesProvider
extends ZoneRulesProvider {
    private static final int MAX_RULES = 16;
    private static final int MAX_LENGTH = 1024;
    private static final int INT_SIZE = 4;
    private static final int FORMAT_VERSION = 1;
    private static final String TZDB_RESOURCE_PATH = "/java/time/zone/tzdb";
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final ZoneOffsetTransitionRule[] EMPTY_LASTRULES = new ZoneOffsetTransitionRule[0];
    private final ResourceBuffer buffer;
    private final int zonesCount;
    private final int zoneIdsOffset;
    private final int zoneIdsOffsets;
    private final int zoneRulesOffsets;

    public TzdbZoneRulesProvider() throws IOException {
        ResourceBuffer resourceBuffer;
        try {
            resourceBuffer = new ResourceBuffer(TZDB_RESOURCE_PATH);
        }
        catch (IOException iOException) {
            throw new IOException("Cannot open the tzdb binary resource");
        }
        int size = resourceBuffer.available();
        TzdbZoneRulesProvider.checkHeader(resourceBuffer);
        resourceBuffer.readString();
        int nbZones = resourceBuffer.readShort() & 0xFFFF;
        if (nbZones > 1024) {
            throw new IOException("Too many zones");
        }
        this.zoneIdsOffset = size - resourceBuffer.available();
        int offsetsLength = nbZones * 4;
        this.zoneIdsOffsets = size - 2 * offsetsLength;
        this.zoneRulesOffsets = size - offsetsLength;
        this.zonesCount = nbZones;
        this.buffer = resourceBuffer;
    }

    private static void checkHeader(ResourceBuffer buffer) throws IOException {
        if (buffer.readByte() != 77 || buffer.readByte() != 69 || buffer.readByte() != 74 || buffer.readByte() != 95 || buffer.readByte() != 84 || buffer.readByte() != 90 || buffer.readByte() != 68) {
            throw new IOException("Wrong tzdb header");
        }
        byte readFormat = buffer.readByte();
        if (readFormat != 1) {
            throw new IOException("Wrong tzdb resource format version, read " + readFormat + ", expected " + 1);
        }
    }

    @Override
    protected Set<String> provideZoneIds() {
        ResourceBuffer resourceBuffer;
        ResourceBuffer resourceBuffer2 = resourceBuffer = this.buffer;
        synchronized (resourceBuffer2) {
            try {
                TzdbZoneRulesProvider.seek(resourceBuffer, this.zoneIdsOffset);
                HashSet<String> zoneIds = new HashSet<String>();
                int i = 0;
                while (i < this.zonesCount) {
                    zoneIds.add(resourceBuffer.readString());
                    ++i;
                }
                return zoneIds;
            }
            catch (IOException e) {
                throw new ZoneRulesException("Error when reading the region ids", e);
            }
        }
    }

    @Override
    @Nullable
    protected ZoneRules provideRules(String zoneId, boolean forCaching) {
        ResourceBuffer resourceBuffer;
        ResourceBuffer resourceBuffer2 = resourceBuffer = this.buffer;
        synchronized (resourceBuffer2) {
            try {
                int ruleIndex = this.binarySearch(resourceBuffer, zoneId);
                if (ruleIndex > -1) {
                    TzdbZoneRulesProvider.seek(resourceBuffer, this.zoneRulesOffsets + ruleIndex * 4);
                    int ruleOffset = resourceBuffer.readInt();
                    TzdbZoneRulesProvider.seek(resourceBuffer, ruleOffset);
                    return TzdbZoneRulesProvider.readZoneRules(resourceBuffer);
                }
                throw new ZoneRulesException("No rule found for zone id " + zoneId);
            }
            catch (IOException e) {
                throw new ZoneRulesException("Error when reading the region rules", e);
            }
        }
    }

    private static void seek(ResourceBuffer buffer, int offset) throws IOException {
        try {
            buffer.seek((long)offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    private int binarySearch(ResourceBuffer resourceBuffer, String zoneId) throws IOException {
        int low = 0;
        int high = this.zonesCount - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            TzdbZoneRulesProvider.seek(resourceBuffer, this.zoneIdsOffsets + mid * 4);
            int offset = resourceBuffer.readInt();
            TzdbZoneRulesProvider.seek(resourceBuffer, offset);
            String id = resourceBuffer.readString();
            int compare = id.compareTo(zoneId);
            if (compare < 0) {
                low = mid + 1;
                continue;
            }
            if (compare > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    @Override
    protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
        throw new ZoneRulesException("History not available");
    }

    private static ZoneRules readZoneRules(ResourceBuffer buffer) throws IOException {
        HashMap<Integer, ZoneOffset> offsets = new HashMap<Integer, ZoneOffset>(0);
        int stdSize = buffer.readShort() & 0xFFFF;
        if (stdSize > 1024) {
            throw new IOException("Too many transitions");
        }
        long[] stdTrans = stdSize == 0 ? EMPTY_LONG_ARRAY : new long[stdSize];
        int i = 0;
        while (i < stdSize) {
            stdTrans[i] = TzdbZoneRulesProvider.readEpochSec(buffer);
            ++i;
        }
        ZoneOffset[] stdOffsets = new ZoneOffset[stdSize + 1];
        int i2 = 0;
        while (i2 < stdOffsets.length) {
            stdOffsets[i2] = TzdbZoneRulesProvider.readOffset(buffer, offsets);
            ++i2;
        }
        int savSize = buffer.readShort() & 0xFFFF;
        if (savSize > 1024) {
            throw new IOException("Too many saving offsets");
        }
        long[] savTrans = savSize == 0 ? EMPTY_LONG_ARRAY : new long[savSize];
        int i3 = 0;
        while (i3 < savSize) {
            savTrans[i3] = TzdbZoneRulesProvider.readEpochSec(buffer);
            ++i3;
        }
        ZoneOffset[] savOffsets = new ZoneOffset[savSize + 1];
        int i4 = 0;
        while (i4 < savOffsets.length) {
            savOffsets[i4] = TzdbZoneRulesProvider.readOffset(buffer, offsets);
            ++i4;
        }
        int ruleSize = buffer.readByte() & 0xFF;
        if (ruleSize > 16) {
            throw new IOException("Too many transition rules");
        }
        ZoneOffsetTransitionRule[] rules = ruleSize == 0 ? EMPTY_LASTRULES : new ZoneOffsetTransitionRule[ruleSize];
        int i5 = 0;
        while (i5 < ruleSize) {
            rules[i5] = TzdbZoneRulesProvider.readZoneOffsetTransitionRule(buffer, offsets);
            ++i5;
        }
        return new ZoneRules(stdTrans, stdOffsets, savTrans, savOffsets, rules);
    }

    private static ZoneOffset readOffset(ResourceBuffer buffer, Map<Integer, ZoneOffset> offsets) throws IOException {
        byte offsetByte = buffer.readByte();
        return TzdbZoneRulesProvider.readOffset(buffer, offsetByte, 127, offsetByte * 900, offsets);
    }

    private static ZoneOffset readOffset(ResourceBuffer buffer, int readByte, int testValue, int seconds, Map<Integer, ZoneOffset> offsets) throws IOException {
        int totalSeconds = readByte == testValue ? buffer.readInt() : seconds;
        Integer key = totalSeconds;
        ZoneOffset zoneOffset = offsets.get(key);
        if (zoneOffset != null) {
            return zoneOffset;
        }
        zoneOffset = ZoneOffset.ofTotalSeconds(totalSeconds);
        offsets.put(key, zoneOffset);
        return zoneOffset;
    }

    private static long readEpochSec(ResourceBuffer buffer) throws IOException {
        int hiByte = buffer.readByte() & 0xFF;
        if (hiByte == 255) {
            long hiInt = buffer.readInt();
            long loInt = buffer.readInt();
            return hiInt << 32 | loInt & 0xFFFFFFFFL;
        }
        int midByte = buffer.readByte() & 0xFF;
        int loByte = buffer.readByte() & 0xFF;
        long tot = (hiByte << 16) + (midByte << 8) + loByte;
        return tot * 900L - 4575744000L;
    }

    private static ZoneOffsetTransitionRule readZoneOffsetTransitionRule(ResourceBuffer buffer, Map<Integer, ZoneOffset> offsets) throws IOException {
        int data = buffer.readInt();
        Month month = Month.of(data >>> 28);
        int dom = ((data & 0xFC00000) >>> 22) - 32;
        int dowByte = (data & 0x380000) >>> 19;
        DayOfWeek dow = dowByte == 0 ? null : DayOfWeek.of(dowByte);
        int timeByte = (data & 0x7C000) >>> 14;
        ZoneOffsetTransitionRule.TimeDefinition defn = ZoneOffsetTransitionRule.TimeDefinition.values()[(data & 0x3000) >>> 12];
        int stdByte = (data & 0xFF0) >>> 4;
        int beforeByte = (data & 0xC) >>> 2;
        int afterByte = data & 3;
        LocalTime time = timeByte == 31 ? LocalTime.ofSecondOfDay(buffer.readInt()) : LocalTime.of(timeByte % 24, 0);
        ZoneOffset std = TzdbZoneRulesProvider.readOffset(buffer, stdByte, 255, (stdByte - 128) * 900, offsets);
        ZoneOffset before = TzdbZoneRulesProvider.readOffset(buffer, beforeByte, 3, std.getTotalSeconds() + beforeByte * 1800, offsets);
        ZoneOffset after = TzdbZoneRulesProvider.readOffset(buffer, afterByte, 3, std.getTotalSeconds() + afterByte * 1800, offsets);
        return ZoneOffsetTransitionRule.of(month, dom, dow, time, timeByte == 24, defn, std, before, after);
    }
}

