/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import ej.annotation.Nullable;
import java.time.DateTimeException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;

public final class DayOfWeek
extends Enum<DayOfWeek>
implements TemporalAccessor,
TemporalAdjuster {
    public static final /* enum */ DayOfWeek MONDAY = new DayOfWeek();
    public static final /* enum */ DayOfWeek TUESDAY = new DayOfWeek();
    public static final /* enum */ DayOfWeek WEDNESDAY = new DayOfWeek();
    public static final /* enum */ DayOfWeek THURSDAY = new DayOfWeek();
    public static final /* enum */ DayOfWeek FRIDAY = new DayOfWeek();
    public static final /* enum */ DayOfWeek SATURDAY = new DayOfWeek();
    public static final /* enum */ DayOfWeek SUNDAY = new DayOfWeek();
    private static final /* synthetic */ DayOfWeek[] ENUM$VALUES;

    static {
        ENUM$VALUES = new DayOfWeek[]{MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY};
    }

    public static DayOfWeek of(int dayOfWeek) {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new DateTimeException("Invalid value for DayOfWeek: " + dayOfWeek);
        }
        DayOfWeek dow = DayOfWeek.values()[dayOfWeek - 1];
        assert (dow != null);
        return dow;
    }

    public static DayOfWeek from(TemporalAccessor temporal) {
        if (temporal instanceof DayOfWeek) {
            return (DayOfWeek)temporal;
        }
        try {
            return DayOfWeek.of(temporal.get(ChronoField.DAY_OF_WEEK));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain DayOfWeek from TemporalAccessor: " + temporal + " of type " + temporal.getClass().getName(), ex);
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    @Override
    public boolean isSupported(@Nullable TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.DAY_OF_WEEK;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.DAY_OF_WEEK) {
            return field.range();
        }
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                return field.range();
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField.DAY_OF_WEEK) {
            return this.getValue();
        }
        ValueRange range = this.range(field);
        if (!range.isIntValue()) {
            throw new UnsupportedTemporalTypeException("Invalid field " + field + " for get() method, use getLong() instead");
        }
        long value = this.getLong(field);
        if (!range.isValidValue(value)) {
            throw new DateTimeException("Invalid value for " + field + " (valid values " + range + "): " + value);
        }
        return (int)value;
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.DAY_OF_WEEK) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    public DayOfWeek plus(long days) {
        int amount = (int)(days % 7L);
        DayOfWeek dayOfWeek = DayOfWeek.values()[(this.ordinal() + (amount + 7)) % 7];
        assert (dayOfWeek != null);
        return dayOfWeek;
    }

    public DayOfWeek minus(long days) {
        return this.plus(-(days % 7L));
    }

    @Override
    @Nullable
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.DAYS;
        }
        if (query == TemporalQueries.zoneId() || query == TemporalQueries.chronology()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.DAY_OF_WEEK, this.getValue());
    }

    public static DayOfWeek[] values() {
        DayOfWeek[] dayOfWeekArray = ENUM$VALUES;
        int n = dayOfWeekArray.length;
        DayOfWeek[] dayOfWeekArray2 = new DayOfWeek[n];
        System.arraycopy(ENUM$VALUES, 0, dayOfWeekArray2, 0, n);
        return dayOfWeekArray2;
    }

    public static DayOfWeek valueOf(String string) {
        return Enum.valueOf(DayOfWeek.class, string);
    }
}

