/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.animation;

import ej.basictool.ArrayTools;
import ej.basictool.ThreadUtils;
import ej.bon.Util;
import ej.microui.MicroUI;
import ej.microui.display.Display;
import ej.mwt.animation.Animation;

public class Animator {
    private final Object monitor = new Object();
    private Animation[] animations = new Animation[0];
    private boolean started = false;
    private boolean ticking = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnimation(Animation animation) {
        Object object = this.monitor;
        synchronized (object) {
            Object[] animations = this.animations;
            if (!ArrayTools.contains((Object[])animations, (Object)animation)) {
                this.animations = (Animation[])ArrayTools.add((Object[])animations, (Object)animation);
                if (!this.started) {
                    this.started = true;
                    this.callOnFlushCompleted(this.createTickRunnable());
                }
            }
        }
    }

    public void stopAnimation(Animation animation) {
        if (!MicroUI.isUIThread() || this.ticking) {
            throw new IllegalStateException();
        }
        this.stopAnimationNoCheck(animation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllAnimations() {
        if (!MicroUI.isUIThread() || this.ticking) {
            throw new IllegalStateException();
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.animations.length > 0) {
                this.animations = new Animation[0];
                this.started = false;
                this.callOnFlushCompleted(Animator.createEmptyRunnable());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAnimationNoCheck(Animation animation) {
        Object object = this.monitor;
        synchronized (object) {
            Animation[] newAnimations = (Animation[])ArrayTools.remove((Object[])this.animations, (Object)animation);
            if (newAnimations != this.animations) {
                this.animations = newAnimations;
                if (newAnimations.length == 0) {
                    this.started = false;
                    this.callOnFlushCompleted(Animator.createEmptyRunnable());
                }
            }
        }
    }

    private void tick() {
        Animation[] animations;
        long currentTimeMillis = Util.platformTimeMillis();
        Animation[] animationArray = animations = this.animations;
        int n = animations.length;
        int n2 = 0;
        while (n2 < n) {
            Animation animation = animationArray[n2];
            assert (animation != null);
            try {
                if (!animation.tick(currentTimeMillis)) {
                    this.stopAnimationNoCheck(animation);
                }
            }
            catch (Exception e) {
                ThreadUtils.handleUncaughtException((Exception)e);
                this.stopAnimationNoCheck(animation);
            }
            ++n2;
        }
    }

    private void runTick(Runnable runnable) {
        this.ticking = true;
        this.tick();
        this.ticking = false;
        if (this.started) {
            this.callOnFlushCompleted(runnable);
        }
    }

    private void callOnFlushCompleted(Runnable runnable) {
        Display display = Display.getDisplay();
        display.callOnFlushCompleted(runnable);
        display.requestFlush();
    }

    private Runnable createTickRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                Animator.this.runTick(this);
            }
        };
    }

    private static Runnable createEmptyRunnable() {
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }
}

