/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.stylesheet.selector;

import ej.annotation.Nullable;
import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.stylesheet.selector.Selector;
import ej.mwt.stylesheet.selector.SelectorHelper;

public class NthChildSelector
implements Selector {
    private final byte index;

    public NthChildSelector(int index) {
        assert (index >= 0 && index <= 255) : "Index of nth child selector must be between 0 and 255.";
        this.index = (byte)index;
    }

    public byte getIndex() {
        return this.index;
    }

    @Override
    public boolean appliesToWidget(Widget widget) {
        Container parent = widget.getParent();
        int index = this.index & 0xFF;
        return parent != null && index < parent.getChildrenCount() && parent.getChild(index) == widget;
    }

    @Override
    public int getSpecificity() {
        return SelectorHelper.getSpecificity(0, 0, 1, 0);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            NthChildSelector other = (NthChildSelector)obj;
            return this.index == other.index;
        }
        return false;
    }

    public int hashCode() {
        return this.index;
    }
}

