/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth;

import ej.annotation.Nullable;
import ej.library.iot.rcommand.bluetooth.commands.AddServiceCommand;
import ej.library.iot.rcommand.bluetooth.commands.ConnectCommand;
import ej.library.iot.rcommand.bluetooth.commands.DisableCommand;
import ej.library.iot.rcommand.bluetooth.commands.DisconnectCommand;
import ej.library.iot.rcommand.bluetooth.commands.DiscoverServicesCommand;
import ej.library.iot.rcommand.bluetooth.commands.EnableCommand;
import ej.library.iot.rcommand.bluetooth.commands.PairCommand;
import ej.library.iot.rcommand.bluetooth.commands.PairReplyCommand;
import ej.library.iot.rcommand.bluetooth.commands.PasskeyReplyCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendNotificationCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendReadRequestCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendReadResponseCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendWriteRequestCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendWriteResponseCommand;
import ej.library.iot.rcommand.bluetooth.commands.StartAdvertisingCommand;
import ej.library.iot.rcommand.bluetooth.commands.StartScanningCommand;
import ej.library.iot.rcommand.bluetooth.commands.StopAdvertisingCommand;
import ej.library.iot.rcommand.bluetooth.commands.StopScanningCommand;
import ej.library.iot.rcommand.bluetooth.notifications.EventNotificationListener;
import ej.rcommand.RemoteNotificationListener;
import ej.rcommand.synchronous.Command;
import ej.rcommand.synchronous.RemoteCommandClient;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class BluetoothHost {
    private static final int ENABLE_COMMAND_TIMEOUT = 5000;
    private static final int DEFAULT_COMMAND_TIMEOUT = 1000;
    private static final int DEFAULT_EVENT_QUEUE_SIZE = 10;
    private static final BluetoothHost INSTANCE = new BluetoothHost();
    private final List<byte[]> eventQueue = new LinkedList<byte[]>();
    @Nullable
    private RemoteCommandClient rcommandClient = null;
    private long commandTimeout = 1000L;
    private int eventQueueSize = 10;
    private boolean enabled = false;

    private BluetoothHost() {
    }

    public static BluetoothHost getInstance() {
        return INSTANCE;
    }

    public void setup(RemoteCommandClient rcommandClient, long commandTimeout, int eventQueueSize) {
        rcommandClient.registerNotificationListener((RemoteNotificationListener)new EventNotificationListener());
        this.rcommandClient = rcommandClient;
        this.commandTimeout = commandTimeout;
        this.eventQueueSize = eventQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvent(byte[] event) {
        if (event.length > 0) {
            List<byte[]> list = this.eventQueue;
            synchronized (list) {
                while (this.eventQueue.size() >= this.eventQueueSize) {
                    System.out.println("Warning: Bluetooth event discarded due to queue being full");
                    this.eventQueue.remove(0);
                }
                this.eventQueue.add(event);
                this.eventQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int waitEvent(byte[] buffer, int bufferLength) {
        List<byte[]> list = this.eventQueue;
        synchronized (list) {
            while (true) {
                if (!this.enabled) {
                    return 0;
                }
                if (!this.eventQueue.isEmpty()) {
                    byte[] event = this.eventQueue.remove(0);
                    if (event.length <= bufferLength) {
                        System.arraycopy(event, 0, buffer, 0, event.length);
                        return event.length;
                    }
                    System.out.println("Warning: Bluetooth event discarded due to buffer being too small");
                    continue;
                }
                try {
                    this.eventQueue.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean enable() {
        this.enabled = this.sendBooleanCommand(new EnableCommand(), 5000L);
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        this.sendCommand(new DisableCommand(), this.commandTimeout);
        this.enabled = false;
        List<byte[]> list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.clear();
            this.eventQueue.notifyAll();
        }
    }

    public boolean startScanning(byte filterAction, byte filterType, byte[] filterData, int filterDataSize) {
        return this.sendBooleanCommand(new StartScanningCommand(filterAction, filterType, filterData, filterDataSize));
    }

    public boolean stopScanning() {
        return this.sendBooleanCommand(new StopScanningCommand());
    }

    public boolean startAdvertising(byte[] advertisementData, int advertisementDataSize) {
        return this.sendBooleanCommand(new StartAdvertisingCommand(advertisementData, advertisementDataSize));
    }

    public boolean stopAdvertising() {
        return this.sendBooleanCommand(new StopAdvertisingCommand());
    }

    public boolean connect(byte[] deviceAddress) {
        return this.sendBooleanCommand(new ConnectCommand(deviceAddress));
    }

    public boolean disconnect(short connHandle) {
        return this.sendBooleanCommand(new DisconnectCommand(connHandle));
    }

    public boolean pair(short connHandle) {
        return this.sendBooleanCommand(new PairCommand(connHandle));
    }

    public boolean pairReply(short connHandle, boolean accept) {
        return this.sendBooleanCommand(new PairReplyCommand(connHandle, accept));
    }

    public boolean passkeyReply(short connHandle, boolean accept, int passkey) {
        return this.sendBooleanCommand(new PasskeyReplyCommand(connHandle, accept, passkey));
    }

    public boolean discoverServices(short connHandle, @Nullable byte[] uuid) {
        return this.sendBooleanCommand(new DiscoverServicesCommand(connHandle, uuid));
    }

    public boolean addService(byte[] service, short[] handles) {
        int numAttr = service[16] + service[17];
        int serviceSize = 18 + numAttr * 20;
        return this.sendBooleanCommand(new AddServiceCommand(service, serviceSize, handles));
    }

    public boolean sendReadRequest(short connHandle, short attributeHandle) {
        return this.sendBooleanCommand(new SendReadRequestCommand(connHandle, attributeHandle));
    }

    public boolean sendWriteRequest(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean noResponse) {
        return this.sendBooleanCommand(new SendWriteRequestCommand(connHandle, attributeHandle, value, valueSize, noResponse));
    }

    public boolean sendReadResponse(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize) {
        return this.sendBooleanCommand(new SendReadResponseCommand(connHandle, attributeHandle, status, value, valueSize));
    }

    public boolean sendWriteResponse(short connHandle, short attributeHandle, byte status) {
        return this.sendBooleanCommand(new SendWriteResponseCommand(connHandle, attributeHandle, status));
    }

    public boolean sendNotification(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean confirm) {
        return this.sendBooleanCommand(new SendNotificationCommand(connHandle, attributeHandle, value, valueSize, confirm));
    }

    @Nullable
    private <T> T sendCommand(Command<T> command, long timeout) {
        RemoteCommandClient rcommandClient = this.rcommandClient;
        if (rcommandClient == null) {
            return null;
        }
        try {
            return (T)rcommandClient.execute(command, timeout);
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            System.out.println("Error: error executing command " + command.getName() + ": " + e.toString());
            return null;
        }
    }

    private boolean sendBooleanCommand(Command<Boolean> command, long timeout) {
        Boolean result = this.sendCommand(command, timeout);
        return result != null && result != false;
    }

    private boolean sendBooleanCommand(Command<Boolean> command) {
        return this.sendBooleanCommand(command, this.commandTimeout);
    }
}

