/*
 * Decompiled with CFR 0.152.
 */
package org.json.me;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONString;
import org.json.me.JSONTokener;

public class JSONObject {
    private static final String EXPECTED_A = "Expected a '";
    private static final String A_JSON_OBJECT_TEXT_MUST = "A JSONObject text must ";
    private static final String JSON_OBJECT = "JSONObject[";
    private static final String NULL_KEY = "Null key.";
    private static final String NULL_POINTER = "Null pointer";
    private static final String IS_NOT = "is not a ";
    private static final String IS_NOT_A_STRING = "is not a string";
    private static final String IS_NOT_A_LONG = "is not a long";
    private static final String IS_NOT_A_JSON_OBJECT = "is not a JSONObject";
    private static final String IS_NOT_AN_INT = "is not a int";
    private static final String IS_NOT_A_NUMBER = "is not a number";
    private static final String IS_NOT_A_BOOLEAN = "is not a Boolean";
    private static final String NOT_FOUND = "not found";
    private static final String IS_NOT_A_JSON_ARRAY = "is not a JSONArray";
    private static final String DUPLICATE_KEY = "Duplicate key \"";
    private static final String EMPTY_JSON = "{}";
    private static final String BAD_VALUE_FROM_TO_JSON_STRING = "Bad value from toJSONString: ";
    private static final String EXPECTED_A_OR = "Expected a ',' or '}'";
    private static final String EXPECTED_A_AFTER_A_KEY = "Expected a ':' after a key";
    private static final String A_JSON_OBJECT_TEXT_MUST_END_WITH = "A JSONObject text must end with '}'";
    private static final String A_JSON_OBJECT_TEXT_MUST_BEGIN_WITH = "A JSONObject text must begin with '{'";
    private static final String JSON_DOES_NOT_ALLOW_NON_FINITE_NUMBERS = "JSON does not allow non-finite numbers";
    private static final String NULL_STRING = "null";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private final Map<String, Object> map = new HashMap<String, Object>();
    public static final Object NULL = new Null();

    public JSONObject() {
    }

    public JSONObject(JSONObject jo, String[] sa) throws JSONException {
        this();
        int i = 0;
        while (i < sa.length) {
            this.putOpt(sa[i], jo.opt(sa[i]));
            ++i;
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError(A_JSON_OBJECT_TEXT_MUST_BEGIN_WITH);
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError(A_JSON_OBJECT_TEXT_MUST_END_WITH);
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError(EXPECTED_A_AFTER_A_KEY);
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError(EXPECTED_A_OR);
    }

    public static Object stringToValue(String string) {
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase(TRUE)) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase(FALSE)) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase(NULL_STRING)) {
            return NULL;
        }
        char initial = string.charAt(0);
        if (initial >= '0' && initial <= '9' || initial == '-') {
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1 || "-0".equals(string)) {
                    Double d = Double.valueOf(string);
                    if (!d.isInfinite() && !d.isNaN()) {
                        return d;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        if (myLong == (long)myLong.intValue()) {
                            return myLong.intValue();
                        }
                        return myLong;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public JSONObject(@Nullable Map<?, ?> map) {
        if (map != null) {
            for (Map.Entry<?, ?> e : map.entrySet()) {
                Object value = e.getValue();
                if (value == null) continue;
                this.map.put(String.valueOf(e.getKey()), value);
            }
        }
    }

    public JSONObject(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value);
        } else if (o instanceof JSONArray) {
            ((JSONArray)o).put(value);
        } else {
            this.put(key, new JSONArray().put(o).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object object = this.opt(key);
        if (object == null) {
            this.put(key, new JSONArray().put(value));
        } else if (object instanceof JSONArray) {
            this.put(key, ((JSONArray)object).put(value));
        } else {
            throw new JSONException(this.jsonObjectError(key, IS_NOT_A_JSON_ARRAY));
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return NULL_STRING;
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object get(String key) throws JSONException {
        if (key == null) {
            throw new JSONException(NULL_KEY);
        }
        Object object = this.opt(key);
        if (object == null) {
            throw new JSONException(this.jsonObjectError(JSONObject.quote(key), NOT_FOUND));
        }
        return object;
    }

    public boolean getBoolean(String key) throws JSONException {
        Object object = this.get(key);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase(FALSE)) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase(TRUE)) {
            return true;
        }
        throw new JSONException(this.jsonObjectError(JSONObject.quote(key), IS_NOT_A_BOOLEAN));
    }

    public double getDouble(String key) throws JSONException {
        Object object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            throw new JSONException(this.jsonObjectError(JSONObject.quote(key), IS_NOT_A_NUMBER));
        }
    }

    public int getInt(String key) throws JSONException {
        Object object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new JSONException(this.jsonObjectError(JSONObject.quote(key), IS_NOT_AN_INT));
        }
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException(this.jsonObjectError(JSONObject.quote(key), IS_NOT_A_JSON_ARRAY));
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException(this.jsonObjectError(JSONObject.quote(key), IS_NOT_A_JSON_OBJECT));
    }

    public long getLong(String key) throws JSONException {
        Object object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
        }
        catch (Exception exception) {
            throw new JSONException(this.jsonObjectError(JSONObject.quote(key), IS_NOT_A_LONG));
        }
    }

    public String getString(String key) throws JSONException {
        Object object = this.get(key);
        if (object instanceof String) {
            return (String)object;
        }
        throw new JSONException(this.jsonObjectError(JSONObject.quote(key), IS_NOT_A_STRING));
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Enumeration keys() {
        return new EnumerationIterator<String>(this.keySet().iterator());
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public int length() {
        return this.map.size();
    }

    @Nullable
    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Iterator<String> keys = this.keySet().iterator();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String trimNumber(String s) {
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String numberToString(Object n) throws JSONException {
        if (n == null) {
            throw new JSONException(NULL_POINTER);
        }
        JSONObject.testValidity(n);
        return JSONObject.trimNumber(n.toString());
    }

    @Nullable
    public Object opt(@Nullable String key) {
        return key == null ? null : this.map.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            return this.getDouble(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Nullable
    public JSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    @Nullable
    public JSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object object = this.opt(key);
        return NULL.equals(object) ? defaultValue : object.toString();
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.put(key, new Double(value));
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.put(key, new Integer(value));
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.put(key, new Long(value));
        return this;
    }

    public JSONObject put(String key, Map<?, ?> value) throws JSONException {
        this.put(key, new JSONObject(value));
        return this;
    }

    public JSONObject put(String key, @Nullable Object value) throws JSONException {
        if (key == null) {
            throw new JSONException(NULL_KEY);
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.map.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOnce(@Nullable String key, @Nullable Object value) throws JSONException {
        if (key != null && value != null) {
            if (this.opt(key) != null) {
                throw new JSONException(DUPLICATE_KEY + key + "\"");
            }
            this.put(key, value);
        }
        return this;
    }

    public JSONObject putOpt(@Nullable String key, @Nullable Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(@Nullable String string) {
        StringWriter sw = new StringWriter();
        try {
            return JSONObject.quote(string, sw).toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private static Writer quote(@Nullable String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    break;
                }
                case '\b': {
                    w.write("\\b");
                    break;
                }
                case '\t': {
                    w.write("\\t");
                    break;
                }
                case '\n': {
                    w.write("\\n");
                    break;
                }
                case '\f': {
                    w.write("\\f");
                    break;
                }
                case '\r': {
                    w.write("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        break;
                    }
                    w.write(c);
                }
            }
            ++i;
        }
        w.write(34);
        return w;
    }

    @Nullable
    public Object remove(String key) {
        return this.map.remove(key);
    }

    static void testValidity(Object o) throws JSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new JSONException(JSON_DOES_NOT_ALLOW_NON_FINITE_NUMBERS);
        }
    }

    @Nullable
    public JSONArray toJSONArray(@Nullable JSONArray names) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        int i = 0;
        while (i < names.length()) {
            ja.put(this.opt(names.getString(i)));
            ++i;
        }
        return ja;
    }

    @Nullable
    public String toString() {
        try {
            Iterator<String> keys = this.keySet().iterator();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                String o = keys.next();
                sb.append(JSONObject.quote(o.toString()));
                sb.append(':');
                sb.append(JSONObject.valueToString(this.map.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    @Nullable
    public static Object wrap(@Nullable Object object) {
        try {
            if (object == null) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                return new JSONArray(coll);
            }
            if (object.getClass().isArray()) {
                return Util.buildJSONArrayFromArray(object);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                return new JSONObject(map);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    String toString(int indentFactor, int indent) throws JSONException {
        block7: {
            n = this.length();
            if (n == 0) {
                return "{}";
            }
            keys = this.keySet().iterator();
            sb = new StringBuffer("{");
            newindent = indent + indentFactor;
            if (n != 1) ** GOTO lbl35
            o = keys.next();
            sb.append(JSONObject.quote(o.toString()));
            sb.append(": ");
            sb.append(JSONObject.valueToString(this.map.get(o), indentFactor, indent));
            break block7;
lbl-1000:
            // 1 sources

            {
                o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                i = 0;
                while (i < newindent) {
                    sb.append(' ');
                    ++i;
                }
                sb.append(JSONObject.quote(o.toString()));
                sb.append(": ");
                sb.append(JSONObject.valueToString(this.map.get(o), indentFactor, newindent));
lbl35:
                // 2 sources

                ** while (keys.hasNext())
            }
lbl36:
            // 1 sources

            if (sb.length() > 1) {
                sb.append('\n');
                i = 0;
                while (i < indent) {
                    sb.append(' ');
                    ++i;
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(@Nullable Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return NULL_STRING;
        }
        if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException(BAD_VALUE_FROM_TO_JSON_STRING + o);
        }
        if (value instanceof Float || value instanceof Double || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return JSONObject.numberToString(value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new JSONObject(map).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JSONArray(coll).toString();
        }
        if (value.getClass().isArray()) {
            return Util.buildJSONArrayFromArray(value).toString();
        }
        return JSONObject.quote(value.toString());
    }

    static String valueToString(@Nullable Object value, int indentFactor, int indent) throws JSONException {
        if (value == null || value.equals(null)) {
            return NULL_STRING;
        }
        try {
            String o;
            if (value instanceof JSONString && (o = ((JSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {}
        if (value instanceof Float || value instanceof Double || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return JSONObject.numberToString(value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        return JSONObject.quote(value.toString());
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean b = false;
            Iterator<String> keys = this.keySet().iterator();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                String k = keys.next();
                writer.write(JSONObject.quote(k.toString()));
                writer.write(58);
                Object v = this.map.get(k);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private String jsonObjectError(String key, String end) {
        return JSON_OBJECT + key + "] " + end + ".";
    }

    private static class EnumerationIterator<E>
    implements Enumeration<E> {
        private final Iterator<E> iterator;

        public EnumerationIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(@Nullable Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return JSONObject.NULL_STRING;
        }
    }

    public static class Util {
        public static JSONArray buildJSONArrayFromArray(Object value) {
            ArrayList<Object> list;
            block10: {
                boolean[] array;
                block17: {
                    byte[] array2;
                    block16: {
                        short[] array3;
                        block15: {
                            float[] array4;
                            block14: {
                                long[] array5;
                                block13: {
                                    double[] array6;
                                    block12: {
                                        char[] array7;
                                        block11: {
                                            int[] array8;
                                            block9: {
                                                Object[] array9;
                                                list = new ArrayList<Object>();
                                                if (!(value instanceof Object[])) break block9;
                                                Object[] objectArray = array9 = (Object[])value;
                                                int n = array9.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    Object o = objectArray[n2];
                                                    list.add(o);
                                                    ++n2;
                                                }
                                                break block10;
                                            }
                                            if (!(value instanceof int[])) break block11;
                                            int[] nArray = array8 = (int[])value;
                                            int n = array8.length;
                                            int n3 = 0;
                                            while (n3 < n) {
                                                Integer o = nArray[n3];
                                                list.add(o);
                                                ++n3;
                                            }
                                            break block10;
                                        }
                                        if (!(value instanceof char[])) break block12;
                                        char[] cArray = array7 = (char[])value;
                                        int n = array7.length;
                                        int n4 = 0;
                                        while (n4 < n) {
                                            Character o = Character.valueOf(cArray[n4]);
                                            list.add(o);
                                            ++n4;
                                        }
                                        break block10;
                                    }
                                    if (!(value instanceof double[])) break block13;
                                    double[] dArray = array6 = (double[])value;
                                    int n = array6.length;
                                    int n5 = 0;
                                    while (n5 < n) {
                                        Double o = dArray[n5];
                                        list.add(o);
                                        ++n5;
                                    }
                                    break block10;
                                }
                                if (!(value instanceof long[])) break block14;
                                long[] lArray = array5 = (long[])value;
                                int n = array5.length;
                                int n6 = 0;
                                while (n6 < n) {
                                    Long o = lArray[n6];
                                    list.add(o);
                                    ++n6;
                                }
                                break block10;
                            }
                            if (!(value instanceof float[])) break block15;
                            float[] fArray = array4 = (float[])value;
                            int n = array4.length;
                            int n7 = 0;
                            while (n7 < n) {
                                Float o = Float.valueOf(fArray[n7]);
                                list.add(o);
                                ++n7;
                            }
                            break block10;
                        }
                        if (!(value instanceof short[])) break block16;
                        short[] sArray = array3 = (short[])value;
                        int n = array3.length;
                        int n8 = 0;
                        while (n8 < n) {
                            Short o = sArray[n8];
                            list.add(o);
                            ++n8;
                        }
                        break block10;
                    }
                    if (!(value instanceof byte[])) break block17;
                    byte[] byArray = array2 = (byte[])value;
                    int n = array2.length;
                    int n9 = 0;
                    while (n9 < n) {
                        Byte o = byArray[n9];
                        list.add(o);
                        ++n9;
                    }
                    break block10;
                }
                if (!(value instanceof boolean[])) break block10;
                boolean[] blArray = array = (boolean[])value;
                int n = array.length;
                int n10 = 0;
                while (n10 < n) {
                    Boolean o = blArray[n10];
                    list.add(o);
                    ++n10;
                }
            }
            return new JSONArray(list);
        }
    }
}

