/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.control.fs;

import com.microej.kf.util.control.fs.CloseFile;
import com.microej.kf.util.control.fs.DeleteFile;
import com.microej.kf.util.control.fs.OpenFile;
import com.microej.kf.util.control.fs.OpenedFilesLimitException;
import com.microej.kf.util.control.fs.SetLengthRandomAccessFile;
import com.microej.kf.util.control.fs.StorageLimitException;
import com.microej.kf.util.control.fs.WriteFile;
import com.microej.kf.util.control.fs.WriteRandomAccessFile;
import com.microej.kf.util.module.SandboxedModule;
import com.microej.kf.util.storage.SandboxedStorage;
import ej.basictool.ArrayTools;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.service.ServiceFactory;
import ej.storage.Storage;
import java.io.File;
import java.util.logging.Logger;

public class FileSystemResourcesController {
    private int maxOpenedFiles;
    private long maxStorageSize;
    private long currentStorageSize;
    private File[] currentOpenedFiles;
    private final Logger logger = Logger.getLogger(FileSystemResourcesController.class.getName());
    private final Module module;

    public FileSystemResourcesController(Module module) {
        this.module = module;
        this.reset();
    }

    public synchronized void reset() {
        SandboxedStorage storage = (SandboxedStorage)((Object)ServiceFactory.getRequiredService(Storage.class));
        this.currentStorageSize = this.computeStorageSize(new File(storage.getRootFolder(this.module)));
        this.maxOpenedFiles = -1;
        this.maxStorageSize = -1L;
        this.currentOpenedFiles = new File[0];
    }

    public synchronized void onStart(SandboxedModule module, OpenFile openFile) throws SecurityException {
        if (this.maxOpenedFiles < 0 || this.currentOpenedFiles.length < this.maxOpenedFiles) {
            return;
        }
        this.logger.fine("Opened files limit reached (only " + this.maxOpenedFiles + " opened files allowed)");
        throw new OpenedFilesLimitException();
    }

    public synchronized void onEnd(SandboxedModule module, OpenFile openFile, boolean withSuccess) {
        if (withSuccess) {
            Kernel.enter();
            this.currentOpenedFiles = (File[])ArrayTools.add((Object[])this.currentOpenedFiles, (Object)openFile.getFile());
            if (openFile.isWriteMode() && openFile.isOverwritten()) {
                this.currentStorageSize -= openFile.getOverwritingSize();
                this.currentStorageSize = this.currentStorageSize < 0L ? 0L : this.currentStorageSize;
            }
        }
    }

    public synchronized void onStart(SandboxedModule module, CloseFile closeFile) throws SecurityException {
    }

    public synchronized void onEnd(SandboxedModule module, CloseFile closeFile, boolean withSuccess) {
        if (withSuccess) {
            Kernel.enter();
            this.currentOpenedFiles = (File[])ArrayTools.remove((Object[])this.currentOpenedFiles, (Object)closeFile.getFile());
        }
    }

    public synchronized void onStart(SandboxedModule module, WriteFile writeFile) throws SecurityException {
        int nbBytes = writeFile.getNbBytes();
        Kernel.enter();
        if (this.maxStorageSize < 0L || this.currentStorageSize + (long)nbBytes <= this.maxStorageSize) {
            return;
        }
        this.logger.fine("Cannot write file: Max storage size will be exceeded. New forecasted storage size: " + (this.currentStorageSize + (long)nbBytes) + "; Max storage size allowed: " + this.maxStorageSize + ")");
        throw new StorageLimitException();
    }

    public synchronized void onEnd(SandboxedModule module, WriteFile writeFile, boolean withSuccess) {
        int writeBytes = writeFile.getNbBytes();
        if (withSuccess) {
            this.currentStorageSize += (long)writeBytes;
        }
    }

    public synchronized void onStart(SandboxedModule module, SetLengthRandomAccessFile setLengthFile) throws SecurityException {
        long nbBytes = setLengthFile.getNbBytes();
        Kernel.enter();
        if (this.maxStorageSize < 0L || this.currentStorageSize + nbBytes <= this.maxStorageSize) {
            return;
        }
        this.logger.fine("Cannot write file: Max storage size will be exceeded. New forecasted storage size: " + (this.currentStorageSize + nbBytes) + "; Max storage size allowed: " + this.maxStorageSize + ")");
        throw new StorageLimitException();
    }

    public synchronized void onEnd(SandboxedModule module, SetLengthRandomAccessFile setLengthFile, boolean withSuccess) {
        long writeBytes = setLengthFile.getNbBytes();
        if (withSuccess) {
            this.currentStorageSize += writeBytes;
        }
    }

    public synchronized void onStart(SandboxedModule module, WriteRandomAccessFile writeFile) throws SecurityException {
        long nbBytes = writeFile.getNbBytes();
        Kernel.enter();
        if (this.maxStorageSize < 0L || this.currentStorageSize + nbBytes <= this.maxStorageSize) {
            return;
        }
        this.logger.fine("Cannot write file: Max storage size will be exceeded. New forecasted storage size: " + (this.currentStorageSize + nbBytes) + "; Max storage size allowed: " + this.maxStorageSize + ")");
        throw new StorageLimitException();
    }

    public synchronized void onEnd(SandboxedModule module, WriteRandomAccessFile writeFile, boolean withSuccess) {
        long nbBytes = writeFile.getNbBytes();
        if (withSuccess) {
            this.currentStorageSize += nbBytes;
        }
    }

    public synchronized void onStart(SandboxedModule module, DeleteFile deleteFile) throws SecurityException {
    }

    public synchronized void onEnd(SandboxedModule module, DeleteFile deleteFile, boolean withSuccess) {
        if (withSuccess) {
            this.currentStorageSize -= deleteFile.getNbBytes();
            this.currentStorageSize = this.currentStorageSize < 0L ? 0L : this.currentStorageSize;
        }
    }

    public synchronized void setMaxStorageSize(long maxStorageSize) {
        this.maxStorageSize = maxStorageSize;
    }

    public synchronized void setMaxOpenedFiles(int maxOpenFiles) {
        this.maxOpenedFiles = maxOpenFiles;
    }

    public synchronized long getStorageSize() {
        return this.currentStorageSize;
    }

    public synchronized File[] getOpenedFiles() {
        return (File[])this.currentOpenedFiles.clone();
    }

    private long computeStorageSize(File dir) {
        long length = 0L;
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                length = file.isFile() ? (length += file.length()) : (length += this.computeStorageSize(file));
                ++n2;
            }
        }
        return length;
    }

    public synchronized long getMaxStorageSize() {
        return this.maxStorageSize;
    }

    public synchronized int getMaxOpenedFiles() {
        return this.maxOpenedFiles;
    }
}

