/*
 * Decompiled with CFR 0.152.
 */
package ej.event;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.basictool.ThreadUtils;
import ej.bon.Constants;
import ej.event.EventQueueDataReader;
import ej.event.EventQueueListener;
import ej.event.EventQueueNatives;
import ej.event.NullEventQueueListener;

public class EventQueue {
    private static final String THREAD_NAME_CONSTANT = "event.thread.name";
    private static final String THREAD_PRIORITY_CONSTANT = "event.thread.priority";
    private static final String THREAD_DAEMON_CONSTANT = "event.thread.daemon";
    private static final int MAX_TYPE_ID = 127;
    private static final int TYPE_OFFSET = 24;
    private static final int TYPE_MASK = 127;
    private static final int INT_24_BITS = 0xFFFFFF;
    private static final int EXTENDED_EVENT_MASK = Integer.MAX_VALUE;
    @Nullable
    private static EventQueue eventQueue = null;
    private EventQueueListener[] eventListeners = new EventQueueListener[0];
    private int nextType;
    private EventQueueListener defaultListener = new NullEventQueueListener();
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    private EventQueue() {
    }

    @Nullable
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public void setDefaultListener(EventQueueListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.valueOf(-6));
        }
        this.defaultListener = listener;
    }

    public synchronized int registerListener(EventQueueListener listener) throws IllegalStateException {
        if (this.nextType > 127) {
            throw new IllegalStateException(String.valueOf(-4));
        }
        int type = this.nextType++;
        this.eventListeners = (EventQueueListener[])ArrayTools.add((Object[])this.eventListeners, (Object)listener);
        return type;
    }

    public synchronized void unregisterListener(int type) throws IllegalArgumentException {
        EventQueueListener[] eventQueueListeners = this.eventListeners;
        if (type < 0 || type >= this.eventListeners.length || eventQueueListeners[type] == null) {
            throw new IllegalArgumentException(String.valueOf(-5));
        }
        eventQueueListeners[type] = null;
    }

    public void offerEvent(int type, int data) {
        if (type < 0 || type >= 127) {
            throw new IllegalArgumentException(String.valueOf(-1));
        }
        if ((data & 0xFFFFFF) != data) {
            throw new IllegalArgumentException(String.valueOf(-3));
        }
        if (!EventQueueNatives.offerEvent(type, data)) {
            throw new IllegalStateException(String.valueOf(-2));
        }
    }

    public void offerExtendedEvent(int type, byte[] data) {
        if (type < 0 || type >= 127) {
            throw new IllegalArgumentException(String.valueOf(-1));
        }
        if ((data.length & 0xFFFFFF) != data.length) {
            throw new IllegalArgumentException(String.valueOf(-3));
        }
        if (!EventQueueNatives.offerExtendedEvent(type, data, data.length)) {
            throw new IllegalStateException(String.valueOf(-2));
        }
    }

    public static synchronized EventQueue getInstance() {
        EventQueue instance = eventQueue;
        if (instance == null) {
            eventQueue = instance = new EventQueue();
            instance.start();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runThread() {
        while (true) {
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    event = EventQueueNatives.waitEvent();
                    eventType = EventQueue.getEventType(event);
                    var4_5 = this;
                    synchronized (var4_5) {
                        queueListeners = this.eventListeners;
                        if (eventType >= 0 && eventType < queueListeners.length) {
                            eventListener = queueListeners[eventType];
                            if (eventListener == null) {
                                eventListener = this.defaultListener;
                            }
                        } else {
                            eventListener = this.defaultListener;
                        }
                        if (event >= 0) {
                            eventListener.handleEvent(eventType, EventQueue.getEventData(event));
                        } else {
                            this.handleExtendedEvent(eventType, eventListener, event & 0x7FFFFFFF);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                this.handleException(t);
                continue;
            }
            {
                ** while (true)
            }
            break;
        }
    }

    private void handleException(Throwable t) {
        Thread.UncaughtExceptionHandler handler = this.uncaughtExceptionHandler;
        if (handler == null) {
            ThreadUtils.handleUncaughtException((Throwable)t);
        } else {
            handler.uncaughtException(Thread.currentThread(), t);
        }
    }

    private void handleExtendedEvent(int eventType, EventQueueListener eventListener, int event) {
        int dataLength = EventQueue.getEventData(event);
        EventQueueDataReader eventQueueDataReader = new EventQueueDataReader();
        EventQueueNatives.startReadExtendedData(dataLength);
        if (eventListener != null) {
            eventListener.handleExtendedEvent(eventType, eventQueueDataReader);
        } else {
            this.defaultListener.handleExtendedEvent(eventType, eventQueueDataReader);
        }
        EventQueueNatives.endReadExtendedData();
    }

    private void start() {
        EventQueueNatives.initialize();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                EventQueue.this.runThread();
            }
        }, Constants.getString((String)THREAD_NAME_CONSTANT));
        if (Constants.getBoolean((String)THREAD_DAEMON_CONSTANT)) {
            t.setDaemon(Constants.getBoolean((String)THREAD_DAEMON_CONSTANT));
        }
        t.setPriority(Constants.getInt((String)THREAD_PRIORITY_CONSTANT));
        t.start();
    }

    private static int getEventType(int event) {
        return event >> 24 & 0x7F;
    }

    private static int getEventData(int event) {
        return event & 0xFFFFFF;
    }
}

