/*
 * Decompiled with CFR 0.152.
 */
package ej.util.concurrent;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SingleThreadExecutor
implements Runnable,
ExecutorService {
    private final Thread thread = new Thread((Runnable)this, SingleThreadExecutor.class.getName());
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private boolean terminated;

    public SingleThreadExecutor() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.thread.isInterrupted()) {
            Runnable active;
            Queue<Runnable> queue = this.tasks;
            synchronized (queue) {
                active = this.tasks.poll();
                if (active == null) {
                    try {
                        this.tasks.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.terminated = true;
                        return;
                    }
                }
            }
            if (active == null) continue;
            active.run();
        }
        this.terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable r) {
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            this.tasks.offer(r);
            this.tasks.notify();
        }
    }

    @Override
    public void shutdown() {
        this.thread.interrupt();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return this.terminated;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }
}

