/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.Parts;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class URL
implements Serializable {
    static final long serialVersionUID = -7627629688361524110L;
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private String protocol;
    @Nullable
    private String host;
    private int port = -1;
    private String file;
    @Nullable
    private transient String query;
    @Nullable
    private String authority;
    private transient String path;
    @Nullable
    private transient String userInfo;
    @Nullable
    private String ref;
    transient URLStreamHandler handler;
    private int hashCode = -1;
    private static final NetPermission SPECIFY_HANDLER_PERMISSION = new NetPermission("specifyStreamHandler");
    @Nullable
    static URLStreamHandlerFactory factory;
    static Hashtable<String, URLStreamHandler> handlers;
    private static Object streamHandlerLock;

    static {
        handlers = new Hashtable();
        streamHandlerLock = new Object();
    }

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file);
    }

    public URL(String protocol, String host, int port, String file, @Nullable URLStreamHandler handler) throws MalformedURLException {
        SecurityManager sm;
        if (handler != null && (sm = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler(sm);
        }
        this.protocol = protocol = protocol.toLowerCase();
        if (host != null) {
            if (host.indexOf(58) >= 0 && !host.startsWith("[")) {
                host = "[" + host + "]";
            }
            this.host = host;
            if (port < -1) {
                throw new MalformedURLException("Invalid port number :" + port);
            }
            this.port = port;
            this.authority = port == -1 ? host : String.valueOf(host) + ":" + port;
        }
        Parts parts = new Parts(file);
        this.path = parts.getPath();
        this.query = parts.getQuery();
        this.file = this.query != null ? String.valueOf(this.path) + "?" + this.query : this.path;
        this.ref = parts.getRef();
        if (handler == null && (handler = URL.getURLStreamHandler(protocol)) == null) {
            throw new MalformedURLException("unknown protocol: " + protocol);
        }
        this.handler = handler;
    }

    public URL(String spec) throws MalformedURLException {
        this(null, spec);
    }

    public URL(@Nullable URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(@Nullable URL context, String spec, @Nullable URLStreamHandler handler) throws MalformedURLException {
        SecurityManager sm;
        String original = spec;
        int start = 0;
        String newProtocol = null;
        boolean aRef = false;
        boolean isRelative = false;
        if (handler != null && (sm = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler(sm);
        }
        try {
            char c;
            int limit = spec.length();
            while (limit > 0 && spec.charAt(limit - 1) <= ' ') {
                --limit;
            }
            while (start < limit && spec.charAt(start) <= ' ') {
                ++start;
            }
            if (spec.regionMatches(true, start, "url:", 0, 4)) {
                start += 4;
            }
            if (start < spec.length() && spec.charAt(start) == '#') {
                aRef = true;
            }
            int i = start;
            while (!aRef && i < limit && (c = spec.charAt(i)) != '/') {
                if (c == ':') {
                    String s = spec.substring(start, i).toLowerCase();
                    if (!this.isValidProtocol(s)) break;
                    newProtocol = s;
                    start = i + 1;
                    break;
                }
                ++i;
            }
            this.protocol = newProtocol;
            if (context != null && (newProtocol == null || newProtocol.equalsIgnoreCase(context.protocol))) {
                if (handler == null) {
                    handler = context.handler;
                }
                if (context.path != null && context.path.startsWith("/")) {
                    newProtocol = null;
                }
                if (newProtocol == null) {
                    this.protocol = context.protocol;
                    this.authority = context.authority;
                    this.userInfo = context.userInfo;
                    this.host = context.host;
                    this.port = context.port;
                    this.file = context.file;
                    this.path = context.path;
                    isRelative = true;
                }
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + original);
            }
            if (handler == null && (handler = URL.getURLStreamHandler(this.protocol)) == null) {
                throw new MalformedURLException("unknown protocol: " + this.protocol);
            }
            this.handler = handler;
            i = spec.indexOf(35, start);
            if (i >= 0) {
                this.ref = spec.substring(i + 1, limit);
                limit = i;
            }
            if (isRelative && start == limit) {
                assert (context != null);
                this.query = context.query;
                if (this.ref == null) {
                    this.ref = context.ref;
                }
            }
            handler.parseURL(this, spec, start, limit);
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (Exception e) {
            MalformedURLException exception = new MalformedURLException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    private boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!this.isLetterProtocol(c)) {
            return false;
        }
        int i = 1;
        while (i < len) {
            c = protocol.charAt(i);
            if (!this.isLetterOrDigitProtocol(c) && c != '.' && c != '+' && c != '-') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isLetterOrDigitProtocol(char c) {
        return this.isLetterProtocol(c) || Character.isDigit(c);
    }

    private boolean isLetterProtocol(char c) {
        return Character.isLowerCase(c) || Character.isUpperCase(c);
    }

    private void checkSpecifyHandler(SecurityManager sm) {
        sm.checkPermission(SPECIFY_HANDLER_PERMISSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(String protocol, String host, int port, String file, String ref) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = protocol;
            this.host = host;
            this.authority = port == -1 ? host : String.valueOf(host) + ":" + port;
            this.port = port;
            this.file = file;
            this.ref = ref;
            this.hashCode = -1;
            int q = file.lastIndexOf(63);
            if (q != -1) {
                this.query = file.substring(q + 1);
                this.path = file.substring(0, q);
            } else {
                this.path = file;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(String protocol, String host, int port, @Nullable String authority, @Nullable String userInfo, String path, @Nullable String query, @Nullable String ref) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.file = query == null ? path : String.valueOf(path) + "?" + query;
            this.userInfo = userInfo;
            this.path = path;
            this.ref = ref;
            this.hashCode = -1;
            this.query = query;
            this.authority = authority;
        }
    }

    @Nullable
    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getUserInfo() {
        return this.userInfo;
    }

    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.handler.getDefaultPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return this.file;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof URL)) {
            return false;
        }
        URL u2 = (URL)obj;
        return this.handler.equals(this, u2);
    }

    public synchronized int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = this.handler.hashCode(this);
        return this.hashCode;
    }

    public boolean sameFile(URL other) {
        return this.handler.sameFile(this, other);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public URLConnection openConnection() throws IOException {
        return this.handler.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    @Nullable
    public final Object getContent(Class[] classes) throws IOException {
        return this.openConnection().getContent(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory fac) {
        Object object = streamHandlerLock;
        synchronized (object) {
            if (factory != null) {
                throw new Error("factory already defined");
            }
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(new RuntimePermission("setFactory"));
            }
            handlers.clear();
            factory = fac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler handler = handlers.get(protocol);
        if (handler == null) {
            boolean checkedWithFactory = false;
            URLStreamHandlerFactory factoryLocal = factory;
            if (factoryLocal != null) {
                handler = factoryLocal.createURLStreamHandler(protocol);
                checkedWithFactory = true;
            }
            if (handler == null) {
                String packagePrefixList = null;
                packagePrefixList = System.getProperty(protocolPathProp, "");
                if (packagePrefixList != "") {
                    packagePrefixList = String.valueOf(packagePrefixList) + "|";
                }
                packagePrefixList = String.valueOf(packagePrefixList) + "sun.net.www.protocol";
                StringTokenizer packagePrefixIter = new StringTokenizer(packagePrefixList, "|");
                while (handler == null && packagePrefixIter.hasMoreTokens()) {
                    String packagePrefix = packagePrefixIter.nextToken().trim();
                    try {
                        String clsName = String.valueOf(packagePrefix) + "." + protocol + ".Handler";
                        Class<?> cls = null;
                        try {
                            cls = Class.forName(clsName);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                        if (cls == null) continue;
                        handler = (URLStreamHandler)cls.newInstance();
                    }
                    catch (Exception exception) {}
                }
            }
            Object object = streamHandlerLock;
            synchronized (object) {
                URLStreamHandler handler2 = null;
                handler2 = handlers.get(protocol);
                if (handler2 != null) {
                    return handler2;
                }
                if (!checkedWithFactory && factoryLocal != null) {
                    handler2 = factoryLocal.createURLStreamHandler(protocol);
                }
                if (handler2 != null) {
                    handler = handler2;
                }
                if (handler != null) {
                    handlers.put(protocol, handler);
                }
            }
        }
        return handler;
    }
}

