/*
 * Decompiled with CFR 0.152.
 */
package ej.motion.elastic;

import ej.bon.XMath;
import ej.motion.Motion;
import ej.motion.MotionManager;
import ej.motion.elastic.ElasticEaseInMotion;
import ej.motion.elastic.ElasticEaseInOutMotion;
import ej.motion.elastic.ElasticEaseOutMotion;
import ej.motion.quad.QuadEaseOutMotion;
import ej.motion.util.TossHelper;

public class ElasticMotionManager
implements MotionManager {
    @Override
    public Motion easeIn(int start, int stop, long duration) {
        return new ElasticEaseInMotion(start, stop, duration);
    }

    @Override
    public Motion easeOut(int start, int stop, long duration) {
        return new ElasticEaseOutMotion(start, stop, duration);
    }

    @Override
    public Motion easeInOut(int start, int stop, long duration) {
        return new ElasticEaseInOutMotion(start, stop, duration);
    }

    @Override
    public Motion toss(int start, int min, int max, float initialSpeed, long duration) {
        int stop = TossHelper.computeExpectedStop(start, initialSpeed, duration);
        if ((stop = XMath.limit((int)stop, (int)min, (int)max)) == min || stop == max) {
            return new ElasticEaseOutMotion(start, stop, duration);
        }
        return new QuadEaseOutMotion(start, stop, duration);
    }
}

