/*
 * Decompiled with CFR 0.152.
 */
package ej.fp;

import ej.fp.Device;
import ej.fp.Image;
import ej.fp.Widget;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public abstract class FrontPanel {
    public static final PrintStream out;
    private static final FrontPanel FrontPanel;

    static {
        try {
            FrontPanel = (FrontPanel)Class.forName("ej.fp.FrontPanelImpl").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new IllegalStateException("Cannot create instance of FrontPanel.");
        }
        out = FrontPanel.getPrintStream();
        FrontPanel.start();
    }

    public static FrontPanel getFrontPanel() {
        return FrontPanel;
    }

    public abstract Device getDevice() throws IllegalStateException;

    protected abstract void start();

    protected abstract PrintStream getPrintStream();

    public abstract void repaintDevice();

    public abstract void repaintDevice(int var1, int var2, int var3, int var4);

    public abstract void repaintWidget(Widget var1);

    public abstract void repaintWidget(Widget var1, int var2, int var3, int var4, int var5);

    public abstract Image newImage(InputStream var1) throws IOException;

    public abstract Image newImage(int var1, int var2, int var3, boolean var4);

    public Image newImage(Image image) {
        Image newImage = this.newImage(image.getWidth(), image.getHeight(), 0, true);
        newImage.drawImage(image);
        return newImage;
    }

    public void verifyUserClass(Class<?> caller, Class<?> expectedType, String classname) throws IllegalArgumentException {
        this.getUserClass(caller, expectedType, classname);
    }

    public abstract Class<?> getUserClass(Class<?> var1, Class<?> var2, String var3) throws IllegalArgumentException;

    public abstract <T> T newUserInstance(Class<?> var1, Class<T> var2, String var3) throws IllegalArgumentException;

    public abstract void checkVersion(String var1, String var2) throws IllegalArgumentException;

    public void disposeIfNotNull(Image ... images) {
        if (images != null) {
            Image[] imageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                if (image != null) {
                    image.dispose();
                }
                ++n2;
            }
        }
    }
}

