/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.module;

import com.microej.kf.util.control.fs.FileSystemResourcesController;
import com.microej.kf.util.control.net.NetResourcesController;
import com.microej.kf.util.module.SandboxedModule;
import com.microej.kf.util.policy.FeaturePolicyEnforcer;
import ej.kf.Feature;
import ej.kf.Kernel;
import ej.kf.Module;
import java.io.IOException;
import org.json.me.JSONException;

public class ApplicationModule
implements SandboxedModule {
    private final Feature feature;
    private final FileSystemResourcesController fsController;
    private final NetResourcesController netController;
    private final FeaturePolicyEnforcer appPolicyEnforcer;

    protected ApplicationModule(Feature feature) {
        this.feature = feature;
        this.fsController = new FileSystemResourcesController((Module)feature);
        this.netController = new NetResourcesController();
        this.appPolicyEnforcer = new FeaturePolicyEnforcer();
    }

    @Override
    public FileSystemResourcesController getFileSystemResourceController() {
        return this.fsController;
    }

    @Override
    public NetResourcesController getNetworkResourceController() {
        return this.netController;
    }

    @Override
    public String getIdentifier() {
        return this.feature.getName();
    }

    @Override
    public Module getModule() {
        return this.feature;
    }

    @Override
    public Feature.State getState() {
        Kernel.enter();
        switch (this.feature.getState()) {
            case UNINSTALLED: {
                return Feature.State.UNINSTALLED;
            }
            case STARTED: {
                return Feature.State.STARTED;
            }
            case INSTALLED: 
            case STOPPED: {
                return Feature.State.INSTALLED;
            }
        }
        throw new IllegalStateException();
    }

    public void applyPolicy() throws JSONException, IOException {
        this.appPolicyEnforcer.applyPolicy(this.feature);
    }

    public void applyThreadPriority() {
        this.appPolicyEnforcer.applyThreadPriority(this.feature);
    }
}

